/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sql.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import net.morilib.sql.util.DBMSDependentException;

public class SQLUtils {
    private String dbms;

    protected SQLUtils(String dbms) {
        this.dbms = dbms;
    }

    protected Object doArray(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return this.getObjects(rs.getArray(column).getResultSet());
    }

    protected Object doBigInt(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getBigDecimal(column).toBigInteger();
    }

    protected Object doBinary(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getBytes(column);
    }

    protected Object doBit(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getBoolean(column);
    }

    protected Object doBlob(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doBoolean(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getBoolean(column);
    }

    protected Object doChar(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getString(column);
    }

    protected Object doClob(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doDatalink(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doDate(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new Date(rs.getDate(column).getTime());
    }

    protected Object doDecimal(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getBigDecimal(column);
    }

    protected Object doDistinct(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doDouble(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getDouble(column);
    }

    protected Object doFloat(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return Float.valueOf(rs.getFloat(column));
    }

    protected Object doInteger(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getInt(column);
    }

    protected Object doJavaObject(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doLongvarbinary(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doLongvarchar(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doNull(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return null;
    }

    protected Object doNumeric(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getBigDecimal(column);
    }

    protected Object doOther(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doReal(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getDouble(column);
    }

    protected Object doRef(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doSmallint(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getInt(column);
    }

    protected Object doStruct(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Object doTime(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new Date(rs.getDate(column).getTime());
    }

    protected Object doTimestamp(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new Date(rs.getDate(column).getTime());
    }

    protected Object doTinyint(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getInt(column);
    }

    protected Object doVarbinary(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getBytes(column);
    }

    protected Object doVarchar(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return rs.getString(column);
    }

    protected Object doType(int type, ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    public Object getObject(ResultSet rs, int column) throws SQLException, DBMSDependentException {
        ResultSetMetaData md = rs.getMetaData();
        switch (md.getColumnType(column)) {
            case 2003: {
                return this.doArray(rs, md, column);
            }
            case -5: {
                return this.doBigInt(rs, md, column);
            }
            case -2: {
                return this.doBinary(rs, md, column);
            }
            case -7: {
                return this.doBit(rs, md, column);
            }
            case 2004: {
                return this.doBlob(rs, md, column);
            }
            case 16: {
                return this.doBoolean(rs, md, column);
            }
            case 1: {
                return this.doChar(rs, md, column);
            }
            case 2005: {
                return this.doClob(rs, md, column);
            }
            case 70: {
                return this.doDatalink(rs, md, column);
            }
            case 91: {
                return this.doDate(rs, md, column);
            }
            case 3: {
                return this.doDecimal(rs, md, column);
            }
            case 2001: {
                return this.doDistinct(rs, md, column);
            }
            case 8: {
                return this.doDouble(rs, md, column);
            }
            case 6: {
                return this.doFloat(rs, md, column);
            }
            case 4: {
                return this.doInteger(rs, md, column);
            }
            case 2000: {
                return this.doJavaObject(rs, md, column);
            }
            case -4: {
                return this.doLongvarbinary(rs, md, column);
            }
            case -1: {
                return this.doLongvarchar(rs, md, column);
            }
            case 0: {
                return this.doNull(rs, md, column);
            }
            case 2: {
                return this.doNumeric(rs, md, column);
            }
            case 1111: {
                return this.doOther(rs, md, column);
            }
            case 7: {
                return this.doReal(rs, md, column);
            }
            case 2006: {
                return this.doRef(rs, md, column);
            }
            case 5: {
                return this.doSmallint(rs, md, column);
            }
            case 2002: {
                return this.doStruct(rs, md, column);
            }
            case 92: {
                return this.doTime(rs, md, column);
            }
            case 93: {
                return this.doTimestamp(rs, md, column);
            }
            case -6: {
                return this.doTinyint(rs, md, column);
            }
            case -3: {
                return this.doVarbinary(rs, md, column);
            }
            case 12: {
                return this.doVarchar(rs, md, column);
            }
        }
        return this.doType(md.getColumnType(column), rs, md, column);
    }

    public Object[] getObjects(ResultSet rs) throws SQLException, DBMSDependentException {
        ResultSetMetaData md = rs.getMetaData();
        Object[] res = new Object[md.getColumnCount()];
        int i = 0;
        while (i < res.length) {
            res[i] = this.getObject(rs, i);
            ++i;
        }
        return res;
    }

    public String getDbms() {
        return this.dbms;
    }
}

