/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import net.morilib.lang.number.intmodulo.IntResidue;

public class IntRingBuffer
implements Serializable {
    private static final long serialVersionUID = 5015372387740172285L;
    private int[] buffer;
    private IntResidue ptrt;
    private IntResidue ptrb;

    public IntRingBuffer(int size) {
        this.buffer = new int[size];
        this.ptrt = this.ptrb = IntResidue.valueOf(0, size);
    }

    public boolean add(int c) {
        this.buffer[this.ptrt.intValue()] = c;
        this.ptrt = this.ptrt.inclement();
        if (this.ptrt.equals(this.ptrb)) {
            this.ptrb = this.ptrb.inclement();
            return false;
        }
        return true;
    }

    public int remove() {
        if (this.ptrt.equals(this.ptrb)) {
            throw new NoSuchElementException();
        }
        int res = this.buffer[this.ptrt.intValue()];
        this.ptrt = this.ptrt.declement();
        return res;
    }

    public int peek() {
        return this.buffer[this.ptrt.intValue()];
    }

    public void put(int c) {
        this.buffer[this.ptrt.intValue()] = c;
    }

    public int get(int c) {
        if (c >= this.ptrt.intModulo()) {
            throw new IndexOutOfBoundsException("" + c);
        }
        if (c > this.ptrt.subtract(this.ptrb).intValue()) {
            throw new NoSuchElementException();
        }
        return this.buffer[this.ptrt.subtract(c).intValue()];
    }

    public boolean isEmpty() {
        return this.ptrt.equals(this.ptrb);
    }

    public void clear() {
        this.ptrt = this.ptrb = IntResidue.valueOf(0, this.buffer.length);
        int i = 0;
        while (i < this.buffer.length) {
            this.buffer[i] = 0;
            ++i;
        }
    }
}

