/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.morilib.util.Objects;
import net.morilib.util.SimpleMap;
import net.morilib.util.collection.MappedCollection;
import net.morilib.util.set.MappedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMap<K, W, V>
implements Map<K, V> {
    private Map<K, W> wrapee;
    private SimpleMap<W, V> composite;
    private final Tf2 tf2 = new Tf2();

    public CompositeMap(Map<K, W> map, SimpleMap<W, V> composite) {
        this.wrapee = map;
        this.composite = composite;
    }

    @Override
    public int size() {
        return this.wrapee.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapee.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapee.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (W w : this.wrapee.values()) {
            if (!Objects.equals(value, this.composite.map(w))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.composite.map(this.wrapee.get(key));
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.wrapee.keySet();
    }

    @Override
    public Collection<V> values() {
        return new MappedCollection<W, V>(this.wrapee.values(), this.composite);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new MappedSet(this.wrapee.entrySet(), this.tf2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class En2
    implements Map.Entry<K, V> {
        private Map.Entry<K, W> wrp;

        private En2(Map.Entry<K, W> wrp) {
            this.wrp = wrp;
        }

        @Override
        public K getKey() {
            return this.wrp.getKey();
        }

        @Override
        public V getValue() {
            return CompositeMap.this.composite.map(this.wrp.getValue());
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tf2
    implements SimpleMap<Map.Entry<K, W>, Map.Entry<K, V>> {
        private Tf2() {
        }

        @Override
        public Map.Entry<K, V> map(Map.Entry<K, W> key) {
            return new En2(key);
        }
    }
}

