/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractCharacterCollection;
import net.morilib.util.primitive.AbstractCharacterVector;
import net.morilib.util.primitive.CharacterCollection;
import net.morilib.util.primitive.CharacterList;
import net.morilib.util.primitive.CharacterSet;
import net.morilib.util.primitive.CharacterSortedSet;
import net.morilib.util.primitive.CharacterVector;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.iterator.CharacterIterators;
import net.morilib.util.primitive.iterator.CharacterVectorIterator;

public final class CharacterCollections {
    public static final CharacterSet EMPTY_SET = new _EmptyS();
    public static final CharacterSortedSet EMPTY_SORTED_SET = new _EmptyS();
    public static final CharacterVector EMPTY_VECTOR = new _EmptyV();

    private CharacterCollections() {
    }

    public static CharacterCollection unmodifiableCollection(CharacterCollection c) {
        return c instanceof UnmodifiableCol ? c : new UnmodifiableCol(c);
    }

    public static CharacterSet unmodifiableSet(CharacterSet set) {
        return set instanceof UnmodifiableSet ? set : new UnmodifiableSet(set);
    }

    public static CharacterSortedSet unmodifiableSortedSet(CharacterSortedSet set) {
        return set instanceof UnmodifiableSSet ? set : new UnmodifiableSSet(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableCol
    extends AbstractCharacterCollection {
        CharacterCollection wrapee;

        UnmodifiableCol(CharacterCollection s) {
            this.wrapee = s;
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllChar(CharacterCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllChar(CharacterCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllChar(Collection<? extends CharacterCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsChar(char v) {
            return this.wrapee.contains(v);
        }

        @Override
        public boolean containsAllChar(CharacterCollection a) {
            return this.wrapee.containsAllChar(a);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public CharacterIterator charIterator() {
            return new Itr(this.wrapee.charIterator());
        }

        @Override
        public boolean removeChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllChar(CharacterCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllChar(CharacterCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public char[] toCharArray() {
            return this.wrapee.toCharArray();
        }

        @Override
        public char[] toCharArray(char[] a) {
            return this.wrapee.toCharArray(a);
        }

        @Override
        public boolean isInfinite() {
            return this.wrapee.isInfinite();
        }

        @Override
        public CharacterSet toSet() {
            return this.wrapee.toSet();
        }

        private static class Itr
        implements CharacterIterator {
            private CharacterIterator itr;

            private Itr(CharacterIterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public char next() {
                return this.itr.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class UnmodifiableSSet
    extends UnmodifiableSet
    implements CharacterSortedSet {
        UnmodifiableSSet(CharacterCollection s) {
            super(s);
        }

        public CharacterSortedSet collect(CharacterSortedSet set) {
            return ((CharacterSortedSet)this.wrapee).collect(set);
        }

        public char first() {
            return ((CharacterSortedSet)this.wrapee).first();
        }

        public CharacterSortedSet headSet(char v) {
            return CharacterCollections.unmodifiableSortedSet(((CharacterSortedSet)this.wrapee).headSet(v));
        }

        public CharacterSortedSet subSet(char s, char e) {
            return CharacterCollections.unmodifiableSortedSet(((CharacterSortedSet)this.wrapee).subSet(s, e));
        }

        public CharacterSortedSet tailSet(char v) {
            return CharacterCollections.unmodifiableSortedSet(((CharacterSortedSet)this.wrapee).tailSet(v));
        }

        public char last() {
            return ((CharacterSortedSet)this.wrapee).last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCol
    implements CharacterSet {
        UnmodifiableSet(CharacterCollection s) {
            super(s);
        }

        public CharacterSet collect(CharacterSet set) {
            return ((CharacterSet)this.wrapee).collect(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _Empty
    extends AbstractCharacterCollection {
        private _Empty() {
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllChar(CharacterCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllChar(CharacterCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllChar(Collection<? extends CharacterCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsChar(char v) {
            return false;
        }

        @Override
        public boolean containsAllChar(CharacterCollection a) {
            return a.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean removeChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllChar(CharacterCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllChar(CharacterCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharacterIterator charIterator() {
            return new CharacterIterator(){

                public boolean hasNext() {
                    return false;
                }

                public char next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isInfinite() {
            return true;
        }
    }

    private static class _EmptyS
    extends _Empty
    implements CharacterSortedSet {
        private _EmptyS() {
        }

        public CharacterSet collect(CharacterSet set) {
            return this;
        }

        public CharacterSortedSet collect(CharacterSortedSet set) {
            return this;
        }

        public char first() {
            throw new NoSuchElementException();
        }

        public CharacterSortedSet headSet(char v) {
            return this;
        }

        public CharacterSortedSet subSet(char s, char e) {
            return this;
        }

        public CharacterSortedSet tailSet(char v) {
            return this;
        }

        public char last() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _EmptyV
    extends AbstractCharacterVector
    implements Serializable {
        private static final long serialVersionUID = 1540238742681016912L;
        private static final _Itr ITR = new _Itr();

        private _EmptyV() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public char first() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Character> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Character get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Character set(int index, Character element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Character element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Character remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<Character> listIterator() {
            return ITR;
        }

        @Override
        public ListIterator<Character> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIterator();
        }

        @Override
        public List<Character> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public void addChar(int index, char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllChar(int index, CharacterCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char getChar(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOfChar(char v) {
            return -1;
        }

        @Override
        public int indexOf(int v) {
            return -1;
        }

        @Override
        public char removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharacterList rest() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public CharacterList rest(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public char setChar(int index, char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char set(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOfChar(char v) {
            return -1;
        }

        @Override
        public CharacterVectorIterator charVectorIterator() {
            return CharacterIterators.NULL_ITERATOR;
        }

        @Override
        public CharacterVectorIterator charVectorIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.charVectorIterator();
        }

        @Override
        public CharacterVector subVector(int start, int end) {
            if (start != 0 || end != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class _Itr
        implements ListIterator<Character> {
            private _Itr() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Character next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public Character previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Character e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Character e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

