/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractLongVector;
import net.morilib.util.primitive.LongCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayVector
extends AbstractLongVector
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 3332872309405682099L;
    private long[] array;
    private transient int size;

    public LongArrayVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new long[initialCapacity];
    }

    public LongArrayVector() {
        this(10);
    }

    public LongArrayVector(LongCollection a) {
        this.array = a.toLongArray();
        this.size = this.array.length;
    }

    public LongArrayVector(LongCollection ... as) {
        this.size = 0;
        LongCollection[] longCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            LongCollection a = longCollectionArray[n2];
            this.size += a.size();
            ++n2;
        }
        int s2 = 0;
        this.array = new long[this.size];
        LongCollection[] longCollectionArray2 = as;
        int n3 = as.length;
        n = 0;
        while (n < n3) {
            LongCollection a = longCollectionArray2[n];
            long[] b = a.toLongArray();
            System.arraycopy(b, 0, this.array, s2, b.length);
            s2 += a.size();
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public LongArrayVector(Collection<? extends LongCollection> as) {
        this.size = 0;
        for (LongCollection longCollection : as) {
            this.size += longCollection.size();
        }
        boolean bl = false;
        this.array = new long[this.size];
        for (LongCollection longCollection : as) {
            void var2_7;
            long[] b = longCollection.toLongArray();
            System.arraycopy(b, 0, this.array, (int)var2_7, b.length);
            var2_7 += longCollection.size();
        }
    }

    public void ensureCapacity(int nsize) {
        if (nsize > this.array.length) {
            int ns = nsize;
            while (ns < this.array.length) {
                int n = ns = this.array.length < 0x4CCCCCCA ? this.array.length / 3 * 5 + 1 : Integer.MAX_VALUE;
            }
            long[] b = new long[ns];
            System.arraycopy(this.array, 0, b, 0, this.size);
            this.array = b;
        }
    }

    @Override
    public void addLong(int index, long v) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        ++this.modCount;
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = v;
        ++this.size;
    }

    @Override
    public boolean addAllLong(int index, LongCollection a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        long[] b = a.toLongArray();
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public long getLong(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public long removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        long res = this.array[index];
        ++this.modCount;
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return res;
    }

    @Override
    public long setLong(int index, long v) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        long res = this.array[index];
        ++this.modCount;
        this.array[index] = v;
        return res;
    }

    @Override
    public boolean addAllLong(LongCollection a) {
        long[] b = a.toLongArray();
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllLong(LongCollection ... as) {
        int nsize = 0;
        LongCollection[] longCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            LongCollection a = longCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            int s2 = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            LongCollection[] longCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                LongCollection a = longCollectionArray2[n];
                long[] b = a.toLongArray();
                System.arraycopy(b, 0, this.array, s2, b.length);
                s2 += a.size();
                ++n;
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllLong(Collection<? extends LongCollection> as) {
        int nsize = 0;
        for (LongCollection longCollection : as) {
            nsize += longCollection.size();
        }
        if (nsize > 0) {
            int n = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            for (LongCollection longCollection : as) {
                void var3_8;
                long[] b = longCollection.toLongArray();
                System.arraycopy(b, 0, this.array, (int)var3_8, b.length);
                var3_8 += longCollection.size();
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long[] toLongArray() {
        long[] b = new long[this.size];
        System.arraycopy(this.array, 0, b, 0, this.size);
        return b;
    }

    @Override
    public long[] toLongArray(long[] a) {
        if (a.length < this.size) {
            return this.toLongArray();
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = this.array.length;
    }
}

