/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairSet<E>
extends AbstractSet<E> {
    private E e1;
    private E e2;

    private PairSet(E e1, E e2) {
        this.e1 = e1;
        this.e2 = e2;
    }

    public static <E> Set<E> newPair(E element1, E element2) {
        if (Objects.equals(element1, element2)) {
            return Collections.singleton(element1);
        }
        return new PairSet<E>(element1, element2);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int cnt = 0;

            @Override
            public boolean hasNext() {
                return this.cnt < 2;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object res = this.cnt == 0 ? PairSet.this.e1 : PairSet.this.e2;
                ++this.cnt;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return Objects.equals(o, this.e1) || Objects.equals(o, this.e2);
    }

    @Override
    public int size() {
        return 2;
    }
}

