/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.util.Arrays2;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.Endianness;

public class FloatArray
extends AbstractUniformArray {
    private float[] array;

    private FloatArray(float[] arr) {
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = new float[arr.length];
        System.arraycopy(arr, 0, this.array, 0, arr.length);
    }

    public FloatArray(FloatArray a) {
        this.array = Arrays2.copy(a.array);
    }

    public static FloatArray newArray(float[] arr) {
        return new FloatArray(arr);
    }

    public static FloatArray malloc(int size) {
        return new FloatArray(new float[size]);
    }

    public byte getByte(int i) {
        return (byte)this.getFloat(i);
    }

    public double getDouble(int i) {
        return this.getFloat(i);
    }

    public float getFloat(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    public int getInt(int i) {
        return (int)this.getFloat(i);
    }

    public long getLong(int i) {
        return (long)this.getFloat(i);
    }

    public short getShort(int i) {
        return (short)this.getFloat(i);
    }

    public void setByte(int i, byte x) {
        this.setFloat(i, x);
    }

    public void setDouble(int i, double x) {
        this.setFloat(i, (float)x);
    }

    public void setFloat(int i, float x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    public void setInt(int i, int x) {
        this.setFloat(i, x);
    }

    public void setLong(int i, long x) {
        this.setFloat(i, x);
    }

    public void setShort(int i, short x) {
        this.setFloat(i, x);
    }

    public int size() {
        return this.array.length;
    }

    public byte[] toByteArray(Endianness e) {
        byte[] res = new byte[this.array.length << 2];
        int i = 0;
        while (i < this.array.length) {
            e.writeInt(res, i << 2, Float.floatToIntBits(this.array[i]));
            ++i;
        }
        return res;
    }

    public float[] toArray() {
        return Arrays2.copy(this.array);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatArray) {
            return Arrays.equals(this.array, ((FloatArray)obj).array);
        }
        return false;
    }
}

