/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar.cjkv;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.morilib.calendar.cjkv.CJKVEra;

public class CJKVGregorianEra
implements CJKVEra {
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy/MM/dd");
    private Calendar newYearEpoch;
    private Calendar epoch;
    private Calendar end;
    private String desc;
    private String init;

    public CJKVGregorianEra(String desc, String letter, Date newYearEpoch, Date epoch, Date end) {
        if (newYearEpoch == null || epoch == null || desc == null) {
            throw new NullPointerException();
        }
        this.newYearEpoch = new GregorianCalendar();
        this.epoch = new GregorianCalendar();
        this.newYearEpoch.setTime(newYearEpoch);
        this.epoch.setTime(epoch);
        if (end != null) {
            this.end = new GregorianCalendar();
            this.end.setTime(end);
        } else {
            this.end = null;
        }
        this.desc = desc;
        this.init = letter;
    }

    public CJKVGregorianEra(String desc, String letter, String newYearEpoch, String epoch, String end) {
        this(desc, letter, CJKVGregorianEra._p(newYearEpoch), CJKVGregorianEra._p(epoch), CJKVGregorianEra._p(end));
    }

    private static Date _p(String ymd) {
        try {
            return ymd == null ? null : FMT.parse(ymd);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Date getEnd() {
        return this.end == null ? null : this.end.getTime();
    }

    @Override
    public Date getEpoch() {
        return this.epoch.getTime();
    }

    @Override
    public int getLeapMonth(int year) {
        return 0;
    }

    @Override
    public Date getNewYearEpoch() {
        return this.newYearEpoch.getTime();
    }

    @Override
    public int getYears() {
        if (this.end == null) {
            return Integer.MAX_VALUE;
        }
        return this.end.get(1) - this.epoch.get(1) + 1;
    }

    @Override
    public boolean isEra(Date d) {
        if (this.end == null) {
            return !this.epoch.getTime().after(d);
        }
        return !this.epoch.getTime().after(d) && !this.end.getTime().before(d);
    }

    @Override
    public int getMonths(int year) {
        if (year < 1) {
            throw new IllegalArgumentException();
        }
        return 12;
    }

    @Override
    public int getDaysOfMonth(int year, int month) {
        Calendar cal = (Calendar)this.newYearEpoch.clone();
        cal.add(1, year - 1);
        cal.set(2, month - 1);
        return cal.getActualMaximum(5);
    }

    @Override
    public int getDaysOfYear(int year) {
        Calendar cal = (Calendar)this.newYearEpoch.clone();
        cal.add(1, year - 1);
        return cal.getActualMaximum(6);
    }

    @Override
    public int getYear(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        int y = cal.get(1) - this.epoch.get(1);
        return this.isEra(d) ? y + 1 : -1;
    }

    @Override
    public int getDaysFromNewYearEpoch(Date d) {
        Calendar cal = (Calendar)this.newYearEpoch.clone();
        GregorianCalendar c2 = new GregorianCalendar();
        boolean Y = true;
        int r = 0;
        if (this.isEra(d)) {
            c2.setTime(d);
            int i = cal.get(1);
            while (i < c2.get(1)) {
                r += cal.getActualMaximum(6);
                ++i;
            }
            return r + c2.get(6) - 1;
        }
        return -1;
    }

    @Override
    public int getDaysFromEpoch(Date d) {
        if (this.isEra(d)) {
            return this.getDaysFromNewYearEpoch(d) - this.epoch.get(6) + 1;
        }
        return -1;
    }

    @Override
    public boolean after(Date d) {
        return this.getEpoch().after(d);
    }

    @Override
    public boolean before(Date d) {
        return this.end != null && this.getEnd().before(d);
    }

    @Override
    public String getInitialLetter() {
        return this.init;
    }

    @Override
    public String getShortDescription() {
        return this.desc.substring(0, 1);
    }

    public String toString() {
        return this.desc;
    }
}

