/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.diff;

import java.util.ArrayList;
import java.util.List;
import net.morilib.diff.Change;
import net.morilib.diff.DeleteScript;
import net.morilib.diff.DiffPatch;
import net.morilib.diff.EditMatrix;
import net.morilib.diff.EditScript;
import net.morilib.diff.InsertScript;
import net.morilib.diff.Patch;
import net.morilib.lang.EqualPredicate;

public final class Diff {
    static final EqualPredicate DEF_EQ = new EqualPredicate(){

        @Override
        public boolean isEqual(Object a, Object b) {
            return a != null ? a.equals(b) : b == null;
        }
    };

    static <T> EditScript<T> _diff0(List<T> a, List<T> b, EqualPredicate eq) {
        EditMatrix s = new EditMatrix(a.size(), b.size());
        int m = 1;
        while (m <= a.size() + b.size()) {
            int i = 0;
            while (i <= a.size()) {
                int j = 0;
                while (j <= b.size()) {
                    Object bt;
                    Object at = i > 0 ? (Object)a.get(i - 1) : null;
                    Object t = bt = j > 0 ? (Object)b.get(j - 1) : null;
                    if (i != 0 || j != 0) {
                        if (s.canApplyRule3(m, i, j, at, bt, eq)) {
                            s.setDistance(i, j, s.getDistance(i - 1, j - 1));
                            s.setScripts(i, j, s.getScripts(i - 1, j - 1));
                        } else if (s.canApplyRule1(m, i, j)) {
                            s.setDistance(i, j, s.getDistance(i, j - 1) + 1);
                            s.setScripts(i, j, new InsertScript<Object>(i, bt, s.getScripts(i, j - 1)));
                        } else if (s.canApplyRule2(m, i, j)) {
                            s.setDistance(i, j, s.getDistance(i - 1, j) + 1);
                            s.setScripts(i, j, new DeleteScript<Object>(i, at, s.getScripts(i - 1, j)));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++m;
        }
        return s.getScripts(a.size(), b.size());
    }

    static <T> List<EditScript<T>> _diff(List<T> a, List<T> b, EqualPredicate eq) {
        ArrayList<EditScript<T>> l = new ArrayList<EditScript<T>>();
        ArrayList<EditScript<T>> f = new ArrayList<EditScript<T>>();
        EditScript<T> s = Diff._diff0(a, b, eq);
        while (s != null) {
            l.add(s);
            s = s.getPrevious();
        }
        int i = l.size() - 2;
        while (i >= 0) {
            f.add((EditScript)l.get(i));
            --i;
        }
        return f;
    }

    public static <T> List<Change<T>> diff(List<T> a, List<T> b) {
        return Change.makechange(Diff._diff(a, b, DEF_EQ));
    }

    public static <T> Patch<T> patch(List<T> a, List<T> b) {
        return new DiffPatch<T>(Diff._diff(a, b, DEF_EQ));
    }

    public static <T> String diffToString(List<T> a, List<T> b) {
        StringBuilder f = new StringBuilder();
        ArrayList<EditScript<T>> l = new ArrayList<EditScript<T>>();
        EditScript<T> s = Diff._diff0(a, b, DEF_EQ);
        while (s != null) {
            l.add(s);
            s = s.getPrevious();
        }
        int i = l.size() - 2;
        while (i >= 0) {
            f.append(((EditScript)l.get(i)).toString()).append("\n");
            --i;
        }
        return f.toString();
    }

    public static <T> List<Change<T>> diff(List<T> a, List<T> b, EqualPredicate eq) {
        return Change.makechange(Diff._diff(a, b, eq));
    }

    public static <T> Patch<T> patch(List<T> a, List<T> b, EqualPredicate eq) {
        return new DiffPatch<T>(Diff._diff(a, b, eq));
    }

    public static <T> String diffToString(List<T> a, List<T> b, EqualPredicate eq) {
        StringBuilder f = new StringBuilder();
        ArrayList<EditScript<T>> l = new ArrayList<EditScript<T>>();
        EditScript<T> s = Diff._diff0(a, b, eq);
        while (s != null) {
            l.add(s);
            s = s.getPrevious();
        }
        int i = l.size() - 2;
        while (i >= 0) {
            f.append(((EditScript)l.get(i)).toString()).append("\n");
            --i;
        }
        return f.toString();
    }
}

