/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.Decimal64;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispAlternatingSeriesNumber;
import net.morilib.lisp.LispArithmeticException;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.sos.LispType;
import net.morilib.util.IntMath;

public final class LispRational
extends LispExactReal
implements Serializable {
    private static final long serialVersionUID = 5519828952722765386L;
    private BigInteger numer;
    private BigInteger denom;

    private LispRational(BigInteger num, BigInteger den) {
        this.numer = num;
        this.denom = den;
    }

    public static final LispExactReal valueOf(Rational r) {
        return LispRational.newRational(r.getNumerator().toBigInteger(), r.getDenominator().toBigInteger());
    }

    public static final LispExactReal newRational(BigInteger num, BigInteger den) {
        BigInteger n = num;
        BigInteger d = den;
        int nsig = num.signum();
        int dsig = den.signum();
        if (dsig == 0) {
            throw new LispArithmeticException("err.divbyzero");
        }
        if (nsig == 0) {
            return LispInteger.ZERO;
        }
        if (dsig < 0) {
            n = n.negate();
            d = d.negate();
        }
        BigInteger gcd = n.gcd(d);
        n = n.divide(gcd);
        if ((d = d.divide(gcd)).equals(BigInteger.ONE)) {
            return LispInteger.valueOf(n);
        }
        return new LispRational(n, d);
    }

    public static final LispExactReal newRational(int num, int den) {
        int n1 = num;
        int d1 = den;
        if (d1 == 0) {
            throw new LispArithmeticException("err.divbyzero");
        }
        if (n1 == 0) {
            return LispInteger.ZERO;
        }
        if (d1 < 0) {
            n1 = -n1;
            d1 = -d1;
        }
        int gcd = IntMath.gcd(n1, d1);
        n1 /= gcd;
        if ((d1 /= gcd) == 1) {
            return LispInteger.valueOf(n1);
        }
        return new LispRational(BigInteger.valueOf(n1), BigInteger.valueOf(d1));
    }

    @Override
    public BigInteger getNumerator() {
        return this.numer;
    }

    @Override
    public BigInteger getDenominator() {
        return this.denom;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.denom);
            BigInteger nn = this.numer.multiply(n.denom).add(n.numer.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = this.denom;
            BigInteger nn = this.numer.add(n.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        return super.add(x);
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.numer);
            BigInteger nn = this.numer.multiply(n.denom);
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = n.multiply(this.denom);
            BigInteger nn = this.numer;
            return LispRational.newRational(nn, nd);
        }
        return super.div(x);
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            return this.numer.equals(n.numer) && this.denom.equals(n.denom);
        }
        if (x instanceof LispInteger) {
            return false;
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            return d1 == ((LispDouble)x).doubleValue();
        }
        return false;
    }

    @Override
    public boolean isLessThan(LispReal x) {
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational n = (LispRational)x;
            BigInteger n1 = this.numer.multiply(n.denom);
            return n1.compareTo(n2 = n.numer.multiply(this.denom)) < 0;
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger n2 = n.multiply(this.denom);
            return this.numer.compareTo(n2) < 0;
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            return d1 < x.getRealDouble();
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return ((LispAlternatingSeriesNumber)x).value.compareTo(this.getRational()) > 0;
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational n = (LispRational)x;
            BigInteger n1 = this.numer.multiply(n.denom);
            return n1.compareTo(n2 = n.numer.multiply(this.denom)) > 0;
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger n2 = n.multiply(this.denom);
            return this.numer.compareTo(n2) > 0;
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            return d1 > x.getRealDouble();
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return ((LispAlternatingSeriesNumber)x).value.compareTo(this.getRational()) < 0;
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.denom);
            BigInteger nn = this.numer.multiply(n.numer);
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = this.denom;
            BigInteger nn = n.multiply(this.numer);
            return LispRational.newRational(nn, nd);
        }
        return super.mul(x);
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.denom);
            BigInteger nn = this.numer.multiply(n.denom).subtract(n.numer.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = this.denom;
            BigInteger nn = this.numer.subtract(n.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        return super.sub(x);
    }

    @Override
    public LispRational uminus() {
        return new LispRational(this.numer.negate(), this.denom);
    }

    @Override
    public int signum() {
        return this.numer.signum();
    }

    @Override
    public LispReal toInexact() {
        return new LispDouble(this.numer.doubleValue() / this.denom.doubleValue());
    }

    @Override
    public String getResult() {
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }

    @Override
    public String print() {
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }

    @Override
    public boolean isRational() {
        return true;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        return new LispString(String.valueOf(this.numer.toString(radix)) + "/" + this.denom.toString(radix));
    }

    @Override
    public boolean isOne() {
        return this.numer.equals(this.denom);
    }

    @Override
    public BigInteger getBigInteger() {
        return this.numer.divide(this.denom);
    }

    @Override
    public int getInt() {
        return this.getBigInteger().intValue();
    }

    @Override
    public long getLong() {
        return this.getBigInteger().longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        BigDecimal n = new BigDecimal(this.numer);
        BigDecimal d = new BigDecimal(this.denom);
        return n.divide(d);
    }

    @Override
    public double getRealDouble() {
        return this.numer.doubleValue() / this.denom.doubleValue();
    }

    @Override
    public long getRealDecimal64() {
        return Decimal64.toDecimal(this.getBigDecimal());
    }

    @Override
    public LispType getType() {
        return LispType.RATIONAL;
    }

    @Override
    public Rational toRational() {
        return Rational.valueOf(Integer2.valueOf(this.numer), Integer2.valueOf(this.denom));
    }

    @Override
    public boolean isUnit() {
        return this.numer.equals(BigInteger.ONE) && this.denom.equals(BigInteger.ONE);
    }

    @Override
    public LispReal invert() {
        return new LispRational(this.denom, this.numer);
    }

    @Override
    public boolean isZero() {
        return this.numer.equals(BigInteger.ZERO);
    }

    @Override
    public double doubleValue() {
        return this.numer.doubleValue() / this.denom.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.numer.floatValue() / this.denom.floatValue();
    }

    @Override
    public int castInt() {
        return this.numer.divide(this.denom).intValue();
    }

    @Override
    public long castLong() {
        return this.numer.divide(this.denom).longValue();
    }

    @Override
    public Integer2 castInteger2() {
        return Integer2.valueOf(this.numer.divide(this.denom));
    }

    @Override
    public Integer2 getInteger2Floor() {
        BigInteger[] r0 = this.numer.divideAndRemainder(this.denom);
        if (r0[1].equals(Integer2.ZERO)) {
            return Integer2.valueOf(r0[0]);
        }
        if (this.numer.signum() > 0 ^ this.denom.signum() > 0) {
            return Integer2.valueOf(r0[0]);
        }
        return Integer2.valueOf(r0[0]).subtract(Integer2.ONE);
    }

    @Override
    public int intFloor() {
        return this.getInteger2Floor().toInt();
    }

    @Override
    public long longFloor() {
        return this.getInteger2Floor().toLong();
    }

    @Override
    public Integer2 getInteger2Ceil() {
        BigInteger[] r0 = this.numer.divideAndRemainder(this.denom);
        if (r0[1].equals(Integer2.ZERO)) {
            return Integer2.valueOf(r0[0]);
        }
        if (this.numer.signum() > 0 ^ this.denom.signum() > 0) {
            return Integer2.valueOf(r0[0]).add(Integer2.ONE);
        }
        return Integer2.valueOf(r0[0]);
    }

    @Override
    public int intCeil() {
        return this.getInteger2Ceil().toInt();
    }

    @Override
    public long longCeil() {
        return this.getInteger2Ceil().toLong();
    }

    @Override
    public boolean isInteger() {
        return this.denom.equals(Integer2.ONE);
    }

    @Override
    public Rational getRational() {
        return this.toRational();
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            return this.numer.equals(n.numer) && this.denom.equals(n.denom);
        }
        return false;
    }

    @Override
    public LispReal floor() {
        if (this.numer.signum() > 0) {
            return LispInteger.valueOf(this.numer.divide(this.denom));
        }
        return this.ceil().subtract(LispInteger.ONE);
    }

    @Override
    public LispReal ceil() {
        if (this.numer.signum() > 0) {
            return this.floor().add(LispInteger.ONE);
        }
        return LispInteger.valueOf(this.numer.divide(this.denom));
    }

    @Override
    public int hashCode() {
        int l = 17;
        l = 37 * l + this.numer.hashCode();
        l = 37 * l + this.denom.hashCode();
        return l;
    }

    @Override
    public String toString() {
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }
}

