/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.arith;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.arith.ILispRatio;
import net.morilib.lisp.math.constants.LispSqrt;

public class LispRatio
extends Datum2
implements ILispRatio {
    public static final LispRatio GOLDEN_RATIO = new LispRatio(LispInteger.ONE, LispSqrt.GOLDEN_NUMBER);
    public static final LispRatio SILVER_RATIO = new LispRatio(LispInteger.ONE, (LispReal)LispMath.sqrt(LispInteger.valueOf(2)));
    LispReal val1;
    LispReal val2;

    public LispRatio(LispReal val1, LispReal val2) {
        if (val1.isZero() || val2.isZero()) {
            throw new ArithmeticException();
        }
        this.val1 = val1;
        this.val2 = val2;
    }

    @Override
    public LispReal getVal1() {
        return this.val1;
    }

    @Override
    public LispReal getVal2() {
        return this.val2;
    }

    @Override
    public LispReal getRatioValue() {
        return this.val1.divide(this.val2);
    }

    @Override
    public LispReal toValue(LispReal r) {
        return this.val2.divide(this.val1).multiply(r);
    }

    @Override
    public LispReal invertedValue(LispReal r) {
        return this.val1.divide(this.val2).multiply(r);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append(this.val1).append(":").append(this.val2);
    }
}

