/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.array.SRFI47Array;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class LispArrayT1
extends SRFI47Array
implements Serializable {
    private int[] bool;

    public LispArrayT1(boolean r, int ... is) {
        super(is);
        int l = LispArrayShape.arraylength(is);
        this.bool = new int[l + 31 >>> 5];
        Arrays.fill(this.bool, r ? -1 : 0);
        if ((l & 0x1F) != 0) {
            int n = (l + 31 >>> 5) - 1;
            this.bool[n] = this.bool[n] & ~(-1 << (l & 0x1F));
        }
    }

    @Override
    public int rank() {
        return this.eIndices.length;
    }

    @Override
    public int startIndex(int dim) {
        if (dim < 0 || dim >= this.eIndices.length) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    @Override
    public int endIndex(int dim) {
        return this.eIndices[dim];
    }

    @Override
    public LispVector toVector() {
        Datum[] r = new Datum[LispArrayShape.arraylength(this.eIndices)];
        int i = 0;
        while (i < r.length) {
            r[i] = LispBoolean.getInstance((this.bool[i >>> 5] & (i & 0x1F)) != 0);
            ++i;
        }
        return new LispVector(r);
    }

    @Override
    public Datum getFromArray(int ... is) {
        int i = LispArrayShape.arrayindex(this.eIndices, is);
        return LispBoolean.getInstance((this.bool[i >>> 5] & 1 << (i & 0x1F)) != 0);
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        int i = LispArrayShape.arrayindex(this.eIndices, is);
        if (d.isTrue()) {
            int n = i >>> 5;
            this.bool[n] = this.bool[n] | 1 << (i & 0x1F);
        } else {
            int n = i >>> 5;
            this.bool[n] = this.bool[n] & ~(1 << (i & 0x1F));
        }
    }

    @Override
    public boolean isEqualTo(LispArray a) {
        if (!this.isIndexEqualTo(a)) {
            return false;
        }
        if (a instanceof LispArrayT1) {
            return Arrays.equals(this.bool, ((LispArrayT1)a).bool);
        }
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public String getTypeSpecifier() {
        return "bool";
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int l = LispArrayShape.arraylength(this.eIndices);
        int i = 0;
        while (i < l && itr.hasNext()) {
            Datum x = itr.next();
            if (x.isTrue()) {
                int n = i >>> 5;
                this.bool[n] = this.bool[n] | 1 << (i & 0x1F);
            } else {
                int n = i >>> 5;
                this.bool[n] = this.bool[n] & ~(1 << (i & 0x1F));
            }
            ++i;
        }
    }

    public static class At1
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = Iterators.nextIf(itr);
            SubrUtils.checkTerminated(itr, body, mesg);
            return new Prototype(d != null && d.isTrue());
        }
    }

    public static class Prototype
    extends Datum2
    implements LispArrayPrototype {
        private boolean bool;

        public Prototype(boolean bool) {
            this.bool = bool;
        }

        @Override
        public LispArray makeArray(int ... is) {
            return new LispArrayT1(this.bool, is);
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<at1 prototype>");
        }
    }
}

