/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.bits;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class IsLogbit
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        int i = SubrUtils.getSmallInt(c1a, mesg);
        if (c2a instanceof LispInteger) {
            BigInteger b = c2a.getBigInteger();
            if (i >= b.bitLength()) {
                return LispBoolean.getInstance(b.signum() < 0);
            }
            if (i < 0) {
                throw mesg.getError("err.require.int.nonnegative", c1a);
            }
            return LispBoolean.getInstance(b.testBit(i));
        }
        throw mesg.getError("err.require.int", c2a);
    }
}

