/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.charset;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.charset.LispCharSet;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.range.integer.IntInterval;
import net.morilib.util.Iterators;

public class UcsRangeToCharSet
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Iterators.nextIf(itr, LispBoolean.FALSE);
        Datum c4a = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (c4a == null || c4a instanceof LispCharSet) {
            int st = SubrUtils.getSmallInt(c1a, mesg);
            int ed = SubrUtils.getSmallInt(c2a, mesg);
            LispCharSet s = (LispCharSet)c4a;
            if (st < 0) {
                throw mesg.getError("err.require.int.nonegative", c1a);
            }
            if (ed < 0) {
                throw mesg.getError("err.require.int.nonegative", c2a);
            }
            if (st > ed) {
                throw mesg.getError("err.range.invalid");
            }
            if (s != null) {
                s.charset = s.charset.join(new IntInterval(st, ed));
                return s;
            }
            return new LispCharSet(new IntInterval(st, ed));
        }
        throw mesg.getError("err.charset.require.charset", c4a);
    }
}

