/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.datetime.LispDate;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.BinaryArgs;

public abstract class CompareFileTime
extends BinaryArgs {
    private long getFileTime(Datum c1a, Environment env, LispMessage mesg) throws IOException {
        if (c1a instanceof LispString) {
            return LispFiles.getFile(env, c1a.getString()).lastModified();
        }
        if (c1a instanceof LispDate) {
            return ((LispDate)c1a).getTime();
        }
        if (c1a instanceof LispInteger) {
            return c1a.getLong();
        }
        throw mesg.getError("err.file.require", c1a);
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        try {
            long t1 = this.getFileTime(c1a, env, mesg);
            long t2 = this.getFileTime(c2a, env, mesg);
            return LispBoolean.getInstance(this.compare(t1, t2));
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }

    protected abstract boolean compare(long var1, long var3);
}

