/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.format;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.format.ArgumentTypeBuf;
import net.morilib.lisp.format.FormatArguments;
import net.morilib.lisp.format.FormatAtom;
import net.morilib.lisp.format.FormatCommandFactory;
import net.morilib.lisp.format.FormatParseException;
import net.morilib.lisp.format.LispFormatException;
import net.morilib.lisp.format.MapFormatCommandFactory;
import net.morilib.lisp.format.ParsedFormat;
import net.morilib.lisp.format.SimpleString;

public class LispFormat {
    private static final LispFormat DEFAULT_INS = new LispFormat();
    private int tilde = 126;
    private int comma = 44;
    private int charf = 39;
    private int atmrk = 64;
    private int colon = 58;
    private int varargc = 86;
    private FormatCommandFactory factory = MapFormatCommandFactory.getInstance();

    private LispFormat() {
    }

    public static final LispFormat getInstance() {
        return DEFAULT_INS;
    }

    private boolean isVarargChar(int c) {
        return Character.toUpperCase(c) == this.varargc;
    }

    private boolean isNum(int c) {
        return c >= 48 && c <= 57;
    }

    private void addSimpleStr(List<FormatAtom> lst, StringBuilder buf) {
        if (buf.length() > 0) {
            String str = buf.toString();
            buf.delete(0, buf.length());
            lst.add(new SimpleString(str));
        }
    }

    private int getInteger(StringBuilder buf) {
        String str = buf.toString();
        buf.delete(0, buf.length());
        return Integer.parseInt(str);
    }

    private void addFormat(List<FormatAtom> lst, int c, ArgumentTypeBuf argbuf) throws FormatParseException {
        lst.add(this.factory.newInstance(c, argbuf));
    }

    private State trans(State st, Reader rd, List<FormatAtom> lst, ArgumentTypeBuf argbuf, StringBuilder buf) throws IOException, FormatParseException {
        State res = st;
        int c = rd.read();
        switch (st) {
            case INIT: {
                if (c < 0) {
                    this.addSimpleStr(lst, buf);
                    res = State.ACCEPT;
                    break;
                }
                if (c == this.tilde) {
                    this.addSimpleStr(lst, buf);
                    res = State.TILDE;
                    break;
                }
                buf.append((char)c);
                break;
            }
            case TILDE: {
                if (c < 0) {
                    throw new FormatParseException();
                }
                if (c == 43) {
                    res = State.TILDE_SIGN;
                    break;
                }
                if (c == 45) {
                    buf.append((char)c);
                    res = State.TILDE_SIGN;
                    break;
                }
                if (this.isNum(c)) {
                    buf.append((char)c);
                    res = State.TILDE_NUM;
                    break;
                }
                if (this.isVarargChar(c)) {
                    argbuf.setVararg(true);
                    res = State.TILDE_COMMA;
                    break;
                }
                if (c == this.charf) {
                    res = State.TILDE_CHAR;
                    break;
                }
                if (c == this.comma) {
                    argbuf.push();
                    break;
                }
                if (c == this.atmrk) {
                    argbuf.setAtmark(true);
                    res = State.FLAG;
                    break;
                }
                if (c == this.colon) {
                    argbuf.setColon(true);
                    res = State.FLAG;
                    break;
                }
                this.addFormat(lst, c, argbuf);
                res = State.INIT;
                break;
            }
            case TILDE_SIGN: {
                if (this.isNum(c)) {
                    buf.append((char)c);
                    res = State.TILDE_NUM;
                    break;
                }
                throw new FormatParseException();
            }
            case TILDE_NUM: {
                if (c < 0) {
                    throw new FormatParseException();
                }
                if (this.isNum(c)) {
                    buf.append((char)c);
                    break;
                }
                if (c == this.comma) {
                    argbuf.setInt(this.getInteger(buf));
                    argbuf.push();
                    res = State.TILDE;
                    break;
                }
                if (c == this.atmrk) {
                    argbuf.setInt(this.getInteger(buf));
                    argbuf.push();
                    argbuf.setAtmark(true);
                    res = State.FLAG;
                    break;
                }
                if (c == this.colon) {
                    argbuf.setInt(this.getInteger(buf));
                    argbuf.push();
                    argbuf.setColon(true);
                    res = State.FLAG;
                    break;
                }
                argbuf.setInt(this.getInteger(buf));
                argbuf.push();
                this.addFormat(lst, c, argbuf);
                res = State.INIT;
                break;
            }
            case TILDE_COMMA: {
                if (c < 0) {
                    throw new FormatParseException();
                }
                if (c == this.comma) {
                    argbuf.push();
                    res = State.TILDE;
                    break;
                }
                if (c == this.atmrk) {
                    argbuf.push();
                    argbuf.setAtmark(true);
                    res = State.FLAG;
                    break;
                }
                if (c == this.colon) {
                    argbuf.push();
                    argbuf.setColon(true);
                    res = State.FLAG;
                    break;
                }
                argbuf.push();
                this.addFormat(lst, c, argbuf);
                res = State.INIT;
                break;
            }
            case TILDE_CHAR: {
                if (c < 0) {
                    throw new FormatParseException();
                }
                argbuf.setChar((char)c);
                res = State.TILDE_COMMA;
                break;
            }
            case FLAG: {
                if (c < 0) {
                    throw new FormatParseException();
                }
                if (c == this.atmrk) {
                    if (argbuf.isAtmark()) {
                        throw new FormatParseException();
                    }
                    argbuf.setAtmark(true);
                    break;
                }
                if (c == this.colon) {
                    if (argbuf.isColon()) {
                        throw new FormatParseException();
                    }
                    argbuf.setColon(true);
                    break;
                }
                this.addFormat(lst, c, argbuf);
                res = State.INIT;
                break;
            }
            case ACCEPT: {
                throw new FormatParseException();
            }
            default: {
                throw new RuntimeException("Internal error:" + (Object)((Object)st));
            }
        }
        return res;
    }

    public ParsedFormat parse(String fmt) throws FormatParseException {
        StringReader rd = new StringReader(fmt);
        State st = State.INIT;
        ArgumentTypeBuf argbuf = new ArgumentTypeBuf();
        ArrayList<FormatAtom> lst = new ArrayList<FormatAtom>();
        StringBuilder buf = new StringBuilder();
        do {
            try {
                st = this.trans(st, rd, lst, argbuf, buf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } while (!st.equals((Object)State.ACCEPT));
        return new ParsedFormat(lst);
    }

    public String format(ParsedFormat pfmt, FormatArguments args) throws LispFormatException {
        StringBuilder buf = new StringBuilder();
        for (FormatAtom atm : pfmt.getAtoms()) {
            buf.append(atm.toString(args));
        }
        return buf.toString();
    }

    public String format(String fmt, FormatArguments args) throws LispFormatException {
        return this.format(this.parse(fmt), args);
    }

    private static enum State {
        INIT,
        TILDE,
        TILDE_SIGN,
        TILDE_NUM,
        TILDE_COMMA,
        TILDE_CHAR,
        FLAG,
        ACCEPT;

    }
}

