/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.constants;

import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispAlternatingSeriesNumber;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.math.constants.ExpNumber;

public class LispExp
extends LispAlternatingSeriesNumber {
    public static final LispExp NAPIER = new LispExp(Rational.ONE, Rational.ONE, Rational.ZERO);
    private Rational val;
    private Rational _scale;
    private Rational _shift;

    LispExp(Rational x, Rational scale, Rational shift) {
        super(new ExpNumber(x, scale, shift));
        this.val = x;
        this._scale = scale;
        this._shift = shift;
    }

    public static LispExactReal valueOf(Rational x, Rational scale, Rational shift) {
        if (scale.isZero()) {
            return LispRational.valueOf(shift);
        }
        if (x.isZero()) {
            return LispRational.valueOf(shift.add(Rational.ONE));
        }
        return new LispExp(x, scale, shift);
    }

    public Rational getX() {
        return this.val;
    }

    public Rational getScale() {
        return this._scale;
    }

    @Override
    public LispExactReal prototype(Rational scale, Rational shift) {
        return LispExp.valueOf(this.val, scale, shift);
    }

    @Override
    public LispExactReal uminus() {
        return new LispExp(this.val, this._scale.negate(), this._shift.negate());
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (!(x instanceof LispExp)) {
            return super.add(x);
        }
        LispExp e = (LispExp)x;
        if (this.val.equals(e.val)) {
            return this.prototype(this._scale.add(e._scale), this._shift.add(e._shift));
        }
        return this.toInexact().add(e.toInexact());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (!(x instanceof LispExp)) {
            return super.add(x);
        }
        LispExp e = (LispExp)x;
        if (this.val.equals(e.val)) {
            return this.prototype(this._scale.subtract(e._scale), this._shift.subtract(e._shift));
        }
        return this.toInexact().sub(e.toInexact());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (!(x instanceof LispExp)) {
            return super.add(x);
        }
        if (this._shift.isZero()) {
            LispExp e = (LispExp)x;
            if (e._shift.isZero()) {
                return LispExp.valueOf(this.val.add(e.val), this._scale.multiply(e._scale), this._shift);
            }
        }
        return this.toInexact().sub(x.toInexact());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (!(x instanceof LispExp)) {
            return super.add(x);
        }
        if (this._shift.isZero()) {
            LispExp e = (LispExp)x;
            if (e._shift.isZero()) {
                return LispExp.valueOf(this.val.subtract(e.val), this._scale.divide(e._scale), this._shift);
            }
        }
        return this.toInexact().sub(x.toInexact());
    }
}

