/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.dist;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.math.stat.dist.LispExponentialDistribution;
import net.morilib.lisp.math.stat.dist.LispGammaDistribution;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.stat.dist.continuous.GammaDistribution;

public class MakeGammaDistribution
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        double d;
        double d2;
        double k = SubrUtils.getDouble(c1a, mesg);
        if (d2 <= 0.0) {
            throw mesg.getError("err.require.real.positive", c1a);
        }
        double theta = SubrUtils.getDouble(c2a, mesg);
        if (d <= 0.0) {
            throw mesg.getError("err.require.real.positive", c2a);
        }
        if (k == 1.0) {
            return new LispExponentialDistribution(1.0 / theta);
        }
        return new LispGammaDistribution(new GammaDistribution(k, theta));
    }
}

