/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net;

import java.util.Arrays;
import net.morilib.lisp.Datum2;
import net.morilib.util.Bytes;

public class LispHardwareAddress
extends Datum2 {
    private byte[] addrs;

    public LispHardwareAddress(byte[] addrs) {
        this.addrs = new byte[addrs.length];
        System.arraycopy(addrs, 0, this.addrs, 0, addrs.length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.addrs);
    }

    public boolean equals(Object o) {
        if (o instanceof LispHardwareAddress) {
            return Arrays.equals(this.addrs, ((LispHardwareAddress)o).addrs);
        }
        return false;
    }

    public static String toString(LispHardwareAddress mac) {
        String dlm = "";
        StringBuilder buf = new StringBuilder();
        byte[] byArray = mac.addrs;
        int n = mac.addrs.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            buf.append(dlm);
            buf.append(String.format("%02X", Bytes.ubyteToInt(b)));
            dlm = ":";
            ++n2;
        }
        return buf.toString();
    }

    public String toPrintString() {
        return LispHardwareAddress.toString(this);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<hardware-address ");
        buf.append(LispHardwareAddress.toString(this)).append(">");
    }
}

