/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.sos.LispClass;
import net.morilib.lisp.sos.LispObject;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.sos.LispTypeException;

public final class SOS {
    private static final SOS INSTANCE = new SOS();
    public final LispClass cTop;
    public final LispClass cCollection;
    public final LispClass cSequence;
    public final LispClass cVector;
    public final LispClass cList;
    public final LispClass cString;
    public final LispClass cNull;
    public final LispClass cPair;
    public final LispClass cChar;
    public final LispClass cNumber;
    public final LispClass cComplex;
    public final LispClass cReal;
    public final LispClass cRational;
    public final LispClass cInteger;
    public final LispClass cBoolean;
    public final LispClass cSymbol;
    public final LispClass cObject;
    public final LispClass cClass;
    public final LispClass cGeneric;
    public final LispClass cKeyword;
    public final LispClass cRegexp;
    private Map<LispType, Set<LispType>> subtypes = new HashMap<LispType, Set<LispType>>();
    private Map<LispType, Set<LispType>> redefed = new HashMap<LispType, Set<LispType>>();
    private Map<LispType, LispClass> klasses = new HashMap<LispType, LispClass>();

    public SOS() {
        this.cTop = this.defcls(LispType.TOP);
        this.cCollection = this.defcls(LispType.COLLECTION);
        this.cSequence = this.defcls(LispType.SEQUENCE);
        this.cVector = this.defcls(LispType.VECTOR);
        this.cList = this.defcls(LispType.LIST);
        this.cString = this.defcls(LispType.STRING);
        this.cNull = this.defcls(LispType.NULL);
        this.cPair = this.defcls(LispType.PAIR);
        this.cChar = this.defcls(LispType.CHAR);
        this.cNumber = this.defcls(LispType.NUMBER);
        this.cComplex = this.defcls(LispType.COMPLEX);
        this.cReal = this.defcls(LispType.REAL);
        this.cRational = this.defcls(LispType.RATIONAL);
        this.cInteger = this.defcls(LispType.INTEGER);
        this.cBoolean = this.defcls(LispType.BOOLEAN);
        this.cSymbol = this.defcls(LispType.SYMBOL);
        this.cObject = this.defcls(LispType.OBJECT);
        this.cClass = this.defcls(LispType.CLASS);
        this.cGeneric = this.defcls(LispType.GENERIC);
        this.cKeyword = this.defcls(LispType.KEYWORD);
        this.cRegexp = this.defcls(LispType.REGEXP);
    }

    private LispClass defcls(LispType lt) {
        LispClass res = new LispClass(this, lt);
        this.klasses.put(lt, res);
        return res;
    }

    public static SOS getInstance() {
        return INSTANCE;
    }

    public LispClass getLispClass(LispType typ) {
        return this.klasses.get(typ);
    }

    private List<LispType> gtypes(List<LispClass> sup) throws LispTypeException {
        ArrayList<LispType> res = new ArrayList<LispType>();
        for (LispClass e : sup) {
            LispType t = e.getObjectType();
            if (!t.contains(LispType.OBJECT)) {
                throw new LispTypeException();
            }
            res.add(e.getObjectType());
        }
        if (!res.contains(LispType.OBJECT)) {
            res.add(LispType.OBJECT);
        }
        return res;
    }

    private List<LispClass> htypes(List<LispType> sup, LispType ot, LispType nt) throws LispTypeException {
        ArrayList<LispClass> res = new ArrayList<LispClass>();
        for (LispType e : sup) {
            res.add(this.getLispClass(e.equals(ot) ? nt : e));
        }
        return res;
    }

    private LispObject gmeta(LispType t) throws LispTypeException {
        LispObject res;
        ArrayList<LispClass> lm = new ArrayList<LispClass>();
        ArrayList<LispObject> om = new ArrayList<LispObject>();
        for (LispType t0 : t.getCPL()) {
            LispObject ot;
            LispClass mt;
            if (t.equals(t0) || (mt = (ot = this.getLispClass(t0).getMetaClass()).getLispClass()) == this.cClass) continue;
            om.add(ot);
            if (lm.contains(mt)) continue;
            lm.add(mt);
        }
        if (lm.size() == 0) {
            LispClass mc = this.cClass;
            res = mc.instantiate();
        } else if (lm.size() == 1) {
            LispClass mc = (LispClass)lm.get(0);
            res = new LispObject((LispObject)om.get(0));
        } else {
            Set<Symbol> e0 = Collections.emptySet();
            LispClass mc = this.defineClass(lm, e0, e0, e0, this.cClass.instantiate());
            res = mc.instantiate();
            for (LispObject o1 : om) {
                res.copyFrom(o1);
            }
        }
        return res;
    }

    public LispClass defineClass(List<LispClass> sup, Collection<Symbol> ins, Collection<Symbol> cls, Collection<Symbol> ecl, LispObject meta) throws LispTypeException {
        LispObject mt2;
        List<LispType> tl = this.gtypes(sup);
        LispType t = new LispType(tl);
        LispObject lispObject = mt2 = meta == null ? this.gmeta(t) : meta;
        if (!mt2.getType().getCPL().contains(LispType.CLASS)) {
            throw new LispTypeException("err.require.metaclass");
        }
        LispClass res = new LispClass(null, this, t, ins, cls, ecl, mt2);
        for (LispType e : tl) {
            Set<LispType> s = this.subtypes.get(e);
            if (s == null) {
                s = new HashSet<LispType>();
                this.subtypes.put(e, s);
            }
            s.add(res.getObjectType());
        }
        this.klasses.put(t, res);
        return res;
    }

    private void redefineSubtypes(LispClass okls, LispClass nkls, Map<Symbol, Datum> vals, Set<LispType> done) throws LispTypeException {
        Set<LispType> ss = this.subtypes.get(okls.getObjectType());
        Set<LispType> rd = this.redefed.get(okls.getObjectType());
        if (ss == null) {
            return;
        }
        for (LispType t : ss) {
            if (rd != null && rd.contains(t) || done.contains(t)) continue;
            LispClass c0 = this.getLispClass(t);
            LispType ot = okls.getObjectType();
            LispType nt = nkls.getObjectType();
            this.redefineClass1(c0, this.htypes(t.getSupers(), ot, nt), c0.getInstanceSlots(), c0.getClassSlots(), c0.getEachClassSlots(), vals, c0.getMetaClass(), done);
            done.add(t);
        }
    }

    private LispClass redefineClass1(LispClass oldkls, List<LispClass> sup, Collection<Symbol> ins, Collection<Symbol> cls, Collection<Symbol> ecl, Map<Symbol, Datum> vals, LispObject meta, Set<LispType> done) throws LispTypeException {
        LispObject mt2;
        oldkls.reinstantiateAll();
        List<LispType> tl = this.gtypes(sup);
        LispType t = new LispType(tl);
        LispObject lispObject = mt2 = meta == null ? this.gmeta(t) : meta;
        if (!mt2.getType().getCPL().contains(LispType.CLASS)) {
            throw new LispTypeException("err.require.metaclass");
        }
        LispClass res = oldkls.redefine(t, ins, cls, ecl, vals, mt2);
        for (LispType e : tl) {
            Set<LispType> s = this.subtypes.get(e);
            if (s == null) {
                s = new HashSet<LispType>();
                this.subtypes.put(e, s);
            }
            s.add(res.getObjectType());
        }
        this.klasses.put(t, res);
        this.redefineSubtypes(oldkls, res, vals, done);
        return res;
    }

    private void deloldkls(LispType oldt) {
        if (this.subtypes.get(oldt) == null) {
            return;
        }
        for (LispType e : this.subtypes.get(oldt)) {
            Set<LispType> s = this.redefed.get(e);
            if (s == null) {
                s = new HashSet<LispType>();
                this.redefed.put(e, s);
            }
            s.add(oldt);
            this.deloldkls(e);
        }
    }

    public LispClass redefineClass(LispClass oldkls, List<LispClass> sup, Collection<Symbol> ins, Collection<Symbol> cls, Collection<Symbol> ecl, Map<Symbol, Datum> vals, LispObject meta) throws LispTypeException {
        this.deloldkls(oldkls.getObjectType());
        LispClass res = this.redefineClass1(oldkls, sup, ins, cls, ecl, vals, meta, new HashSet<LispType>());
        return res;
    }
}

