/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.relation.LispDBRow;
import net.morilib.lisp.relation.LispRelationException;
import net.morilib.lisp.relation.LispResultBag;
import net.morilib.lisp.sql.LispJdbcClosable;
import net.morilib.lisp.sql.LispSQLUtils;
import net.morilib.sql.util.DBMSDependentException;

public class LispJdbcResultBag
extends LispResultBag
implements LispJdbcClosable {
    private ResultSet resultSet;
    private boolean closed = false;

    LispJdbcResultBag(ResultSet rs) {
        this.resultSet = rs;
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public void deleteRow(int row) throws LispRelationException {
        try {
            int r = this.resultSet.getRow();
            this.resultSet.absolute(row);
            this.resultSet.deleteRow();
            this.resultSet.absolute(r);
        }
        catch (SQLException e) {
            throw new LispRelationException(e);
        }
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    public void insertRow(Datum ... data) throws LispRelationException {
        try {
            LispSQLUtils utils = LispSQLUtils.getSQLUtils();
            this.resultSet.moveToInsertRow();
            int i = 0;
            while (i < data.length) {
                utils.updateDatum(this.resultSet, i + 1, data[i]);
                ++i;
            }
            this.resultSet.moveToCurrentRow();
        }
        catch (SQLException e) {
            throw new LispRelationException(e);
        }
        catch (DBMSDependentException e) {
            throw new LispRelationException(e);
        }
    }

    public LispDBRow referRow(int row) throws LispRelationException {
        try {
            int r = this.resultSet.getRow();
            this.resultSet.absolute(row);
            Row res = new Row();
            this.resultSet.absolute(r);
            return res;
        }
        catch (SQLException e) {
            throw new LispRelationException(e);
        }
    }

    @Override
    public LispDBRow getRow() throws LispRelationException {
        return new Row();
    }

    @Override
    public LispResultBag rest() throws LispRelationException {
        try {
            this.resultSet.next();
            return this;
        }
        catch (SQLException e) {
            throw new LispRelationException(e);
        }
    }

    @Override
    public boolean isAfterLast() throws LispRelationException {
        try {
            return this.resultSet.isAfterLast();
        }
        catch (SQLException e) {
            throw new LispRelationException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        this.resultSet.close();
        this.closed = true;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<result-bag>");
    }

    private class Row
    extends LispDBRow {
        private Datum[] data;

        private Row() throws LispRelationException {
            try {
                LispSQLUtils utils = LispSQLUtils.getSQLUtils();
                int arity = LispJdbcResultBag.this.resultSet.getMetaData().getColumnCount();
                this.data = new Datum[arity];
                int i = 0;
                while (i < arity) {
                    this.data[i] = utils.getDatum(LispJdbcResultBag.this.resultSet, i + 1);
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new LispRelationException(e);
            }
            catch (DBMSDependentException e) {
                throw new LispRelationException(e);
            }
        }

        @Override
        public Datum get(Object column) throws LispRelationException {
            try {
                return this.data[LispJdbcResultBag.this.resultSet.findColumn(column.toString()) - 1];
            }
            catch (SQLException e) {
                throw new LispRelationException(e);
            }
        }

        @Override
        public void set(Object column, Datum value) throws LispRelationException {
            try {
                this.data[((LispJdbcResultBag)LispJdbcResultBag.this).resultSet.findColumn((String)column.toString()) - 1] = value;
            }
            catch (SQLException e) {
                throw new LispRelationException(e);
            }
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<result-bag-row>");
        }

        @Override
        public Datum getByList() throws LispRelationException {
            ConsListBuilder l = new ConsListBuilder();
            int i = 0;
            while (i < this.data.length) {
                l.append(this.data[i]);
                ++i;
            }
            return l.get();
        }
    }
}

