/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispJavaUtils;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.ChangeListenable;
import net.morilib.lisp.swing.ILispComponent;
import net.morilib.lisp.swing.LightweightGUIElement;

public class LispTabbedPane
extends LightweightGUIElement
implements ILispComponent,
ChangeListenable {
    private JTabbedPane tabs;
    private List<Datum> tabslist;

    public LispTabbedPane(JTabbedPane tabs, List<Datum> tabslist) {
        this.tabs = tabs;
        this.tabslist = tabslist;
    }

    public LispTabbedPane(JTabbedPane tabs) {
        this.tabs = tabs;
        this.tabslist = new ArrayList<Datum>();
        int i = 0;
        while (i < tabs.getTabCount()) {
            this.tabslist.add(LispJavaUtils.newInstance(tabs.getTabComponentAt(i)));
            ++i;
        }
    }

    @Override
    public JComponent getComponent() {
        return this.tabs;
    }

    @Override
    public Component getAWTComponent() {
        return this.tabs;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.tabs.addChangeListener(listener);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<tabbed-pane>");
    }

    public static class GetSelectedTab
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispTabbedPane) {
                int i = ((LispTabbedPane)c1a).tabs.getSelectedIndex();
                return (Datum)((LispTabbedPane)c1a).tabslist.get(i);
            }
            throw mesg.getError("err.swing.require.tabbedpane", c1a);
        }
    }

    public static class MakeTabbedPane
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            JTabbedPane pne = new JTabbedPane();
            ArrayList<Datum> lst = new ArrayList<Datum>();
            while (itr.hasNext()) {
                Datum d = itr.next();
                if (d instanceof Cons) {
                    Cons c = (Cons)d;
                    if (!(c.getCdr() instanceof ILispComponent)) {
                        throw mesg.getError("err.swing.require.component", d);
                    }
                    ILispComponent lc = (ILispComponent)((Object)c.getCdr());
                    pne.add(SubrUtils.getString(c.getCar(), mesg), lc.getComponent());
                    lst.add((Datum)((Object)lc));
                    continue;
                }
                throw mesg.getError("err.require.pair", d);
            }
            return new LispTabbedPane(pne, lst);
        }
    }
}

