/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.topology;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.topology.AbstractLispTopology;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;

public class LispIntersection
extends AbstractLispTopology
implements Iterable<ILispTopology> {
    ILispTopology[] topologies;

    private LispIntersection(ILispTopology[] ts, boolean b) {
        this.topologies = ts;
    }

    private LispIntersection(ILispTopology ... ts) {
        this.topologies = new ILispTopology[ts.length];
        System.arraycopy(ts, 0, this.topologies, 0, ts.length);
    }

    private LispIntersection(List<ILispTopology> ts) {
        this.topologies = ts.toArray(new ILispTopology[0]);
    }

    public static ILispTopology newInstance(ILispTopology ... ts) {
        ArrayList<ILispTopology> l = new ArrayList<ILispTopology>();
        int i = 0;
        while (i < ts.length) {
            block7: {
                int j = i + 1;
                while (j < ts.length) {
                    if (!ts[j].isContained(ts[i])) {
                        ++j;
                        continue;
                    }
                    break block7;
                }
                l.add(ts[i]);
            }
            ++i;
        }
        switch (l.size()) {
            case 0: {
                return LispBoolean.TRUE;
            }
            case 1: {
                return (ILispTopology)l.get(0);
            }
        }
        return new LispIntersection(l);
    }

    @Override
    public boolean isNeighborhoodOf(Datum d) {
        ILispTopology[] iLispTopologyArray = this.topologies;
        int n = this.topologies.length;
        int n2 = 0;
        while (n2 < n) {
            ILispTopology t = iLispTopologyArray[n2];
            if (!t.isNeighborhoodOf(d)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public ILispTopology interior() {
        ILispTopology[] ts = new ILispTopology[this.topologies.length];
        int i = 0;
        while (i < ts.length) {
            ts[i] = this.topologies[i].interior();
            if (ts[i] == null) {
                return LispBoolean.FALSE;
            }
            ++i;
        }
        return new LispIntersection(ts, false);
    }

    @Override
    public ILispTopology closure() {
        ILispTopology[] ts = new ILispTopology[this.topologies.length];
        int i = 0;
        while (i < ts.length) {
            ts[i] = this.topologies[i].closure();
            if (ts[i] == null) {
                return LispBoolean.TRUE;
            }
            ++i;
        }
        return new LispIntersection(ts, false);
    }

    @Override
    public boolean isOpen() {
        ILispTopology[] iLispTopologyArray = this.topologies;
        int n = this.topologies.length;
        int n2 = 0;
        while (n2 < n) {
            ILispTopology t = iLispTopologyArray[n2];
            if (!t.isOpen()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public LispCardinality cardinality() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        ILispTopology[] iLispTopologyArray = this.topologies;
        int n = this.topologies.length;
        int n2 = 0;
        while (n2 < n) {
            ILispTopology t = iLispTopologyArray[n2];
            if (t.isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isUniverse() {
        ILispTopology[] iLispTopologyArray = this.topologies;
        int n = this.topologies.length;
        int n2 = 0;
        while (n2 < n) {
            ILispTopology t = iLispTopologyArray[n2];
            if (!t.isUniverse()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Iterator<ILispTopology> iterator() {
        final int[] i = new int[]{0};
        return new Iterator<ILispTopology>(){

            @Override
            public boolean hasNext() {
                return i[0] < LispIntersection.this.topologies.length;
            }

            @Override
            public ILispTopology next() {
                if (i[0] >= LispIntersection.this.topologies.length) {
                    throw new NoSuchElementException();
                }
                int n = i[0];
                i[0] = n + 1;
                return LispIntersection.this.topologies[n];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<intersection of sets>");
    }
}

