/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.topology;

import net.morilib.lisp.Datum;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.topology.AbstractLispTopology;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;
import net.morilib.lisp.topology.LispRealNumberSet;
import net.morilib.range.Interval;
import net.morilib.range.Intervals;
import net.morilib.range.Range;

public abstract class LispNumberClassTopology
extends AbstractLispTopology {
    public static final LispNumberClassTopology O = new LispNumberClassTopology(16392){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            return d instanceof LispOctonion;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                return false;
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.C;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of octonions>");
        }
    };
    public static final LispNumberClassTopology H = new LispNumberClassTopology(16388){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            return d instanceof LispQuaternion;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                return false;
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.C;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of quaternions>");
        }
    };
    public static final LispNumberClassTopology C = new LispNumberClassTopology(16386){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            return d instanceof LispComplex;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                return false;
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.C;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of complex numbers>");
        }
    };
    public static final LispNumberClassTopology R = new LispNumberClassTopology(16385){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            return d instanceof LispReal;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                return ((LispRealNumberSet)t).getRange().isUniverse();
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.C;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of real numbers>");
        }
    };
    public static final LispNumberClassTopology Q = new LispNumberClassTopology(8192){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            if (d instanceof LispReal) {
                return ((LispReal)d).isRational();
            }
            return false;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                return ((LispRealNumberSet)t).getRange().isUniverse();
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.A;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of rational numbers>");
        }
    };
    public static final LispNumberClassTopology Z = new LispNumberClassTopology(4096){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            if (d instanceof LispReal) {
                return ((LispReal)d).isInteger();
            }
            return false;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                return ((LispRealNumberSet)t).getRange().isUniverse();
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.A;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of integers>");
        }
    };
    public static final LispNumberClassTopology N = new LispNumberClassTopology(2049){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            if (d instanceof LispReal) {
                LispReal r = (LispReal)d;
                return r.isInteger() && r.signum() >= 0;
            }
            return false;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                Range r = ((LispRealNumberSet)t).getRange();
                return r.containsAll(Intervals.newSupremumlessInterval(LispInteger.ZERO, false));
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.A;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of natural numbers with 0>");
        }
    };
    public static final LispNumberClassTopology NPLUS = new LispNumberClassTopology(2048){

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            if (d instanceof LispReal) {
                LispReal r = (LispReal)d;
                return r.isInteger() && r.signum() > 0;
            }
            return false;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            if (t instanceof LispRealNumberSet) {
                Range r = ((LispRealNumberSet)t).getRange();
                return r.containsAll(Intervals.newSupremumlessInterval(LispInteger.ONE, false));
            }
            return super.isContained(t);
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.A;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<class of natural numbers>");
        }
    };
    private int order;

    private LispNumberClassTopology(int order) {
        this.order = order;
    }

    static boolean contained(LispNumberClassTopology t, LispRealNumberSet s) {
        Range set = s.getRange();
        if (R.isContained(t)) {
            return false;
        }
        if (Q.isContained(t)) {
            return false;
        }
        if (N.equals(t) && Intervals.newInfimumlessInterval(LispInteger.ZERO, true).containsAll(set)) {
            return true;
        }
        if (NPLUS.equals(t) && Intervals.newInfimumlessInterval(LispInteger.ONE, true).containsAll(set)) {
            return true;
        }
        for (Interval i : set.intervals()) {
            Object inf = i.getInfimumBound();
            Object sup = i.getSupremumBound();
            if (!(inf instanceof LispReal) || !(sup instanceof LispReal)) {
                return false;
            }
            LispReal si = (LispReal)inf;
            LispReal ss = (LispReal)sup;
            LispReal ri = si.ceil();
            LispReal rs = ss.ceil();
            if (si.isInteger() && i.isInfimumOpen()) {
                ri = ri.add(LispInteger.ONE);
            }
            if (!ri.isEqualTo(rs)) {
                return false;
            }
            if ((!si.isInteger() || i.isInfimumOpen()) && (!ss.isInteger() || i.isSupremumOpen())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isContained(ILispTopology t) {
        if (t instanceof LispNumberClassTopology) {
            return this.order <= ((LispNumberClassTopology)t).order;
        }
        return super.isContained(t);
    }

    @Override
    public boolean isIndependent(ILispTopology t) {
        if (t instanceof LispRealNumberSet) {
            return LispNumberClassTopology.contained(this, (LispRealNumberSet)t);
        }
        return !(t instanceof LispNumberClassTopology) && super.isIndependent(t);
    }

    @Override
    public ILispTopology interior() {
        return this;
    }

    @Override
    public ILispTopology closure() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    /* synthetic */ LispNumberClassTopology(int n, LispNumberClassTopology lispNumberClassTopology) {
        this(n);
    }
}

