/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.operator;

import net.morilib.parser.operator.OperatorStack;
import net.morilib.util.IntMath;

public abstract class OperatorInfo<T> {
    public static final Associative LEFT = new Associative(1);
    public static final Associative EQUAL = new Associative(0);
    public static final Associative RIGHT = new Associative(-1);
    int precedenceF;
    int precedenceG;
    private Associative associative;
    private boolean nextUnary;
    private static final OperatorInfo<Object> BEGIN = new OperatorInfo<Object>(Integer.MIN_VALUE, EQUAL, true){

        public String toString() {
            return "c";
        }

        @Override
        public Object reduce(Object s, OperatorStack<Object> stack) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int howManyTerms() {
            return 0;
        }
    };
    private static final OperatorInfo<Object> END = new OperatorInfo<Object>(Integer.MIN_VALUE, EQUAL, false){

        public String toString() {
            return "$";
        }

        @Override
        public Object reduce(Object s, OperatorStack<Object> stack) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int howManyTerms() {
            return 0;
        }
    };

    protected OperatorInfo(int precedenceF, int precedenceG, Associative associative, boolean nextUnary) {
        this.precedenceF = precedenceF;
        this.precedenceG = precedenceG;
        this.associative = associative;
        this.nextUnary = nextUnary;
    }

    protected OperatorInfo(int precedence, Associative associative, boolean nextUnary) {
        this(precedence, precedence, associative, nextUnary);
    }

    public static final <T> OperatorInfo<T> getBegin() {
        return BEGIN;
    }

    public static final <T> OperatorInfo<T> getEnd() {
        return END;
    }

    public void shift() {
    }

    public abstract T reduce(Object var1, OperatorStack<T> var2);

    public abstract int howManyTerms();

    public boolean canNextUnary() {
        return this.nextUnary;
    }

    int comparePrecedence(OperatorInfo<T> op) {
        int r = IntMath.compareTo(this.precedenceF, op.precedenceG);
        if (r == 0) {
            if (this.associative == null) {
                throw new NullPointerException();
            }
            return this.associative.assoc;
        }
        return r;
    }

    boolean isAssociative(OperatorInfo<T> op) {
        int r = IntMath.compareTo(this.precedenceF, op.precedenceG);
        return r != 0 || this.associative != null;
    }

    public static final class Associative {
        private int assoc;

        private Associative(int assoc) {
            this.assoc = assoc;
        }

        public boolean isEqualTo(Associative a) {
            return this.assoc == a.assoc;
        }
    }
}

