/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class IndexIterator<E>
implements ListIterator<E> {
    private int begin = 0;
    private int end;
    private boolean goodState = false;
    protected int index;

    public IndexIterator(int index, int begin, int end) {
        this.begin = begin;
        this.end = end;
        this.index = index;
    }

    public IndexIterator(int begin, int end) {
        this(0, begin, end);
    }

    protected abstract E get(int var1);

    protected abstract void set(int var1, E var2);

    protected boolean isInRange(int index) {
        return index >= this.begin && index < this.end;
    }

    @Override
    public boolean hasNext() {
        return this.index + this.begin < this.end;
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0 || !this.goodState && this.end - this.begin > 0;
    }

    @Override
    public int nextIndex() {
        int n;
        this.goodState = true;
        if (!this.hasNext()) {
            n = this.end - this.begin;
        } else {
            int n2 = this.index;
            n = n2;
            this.index = n2 + 1;
        }
        return n;
    }

    @Override
    public int previousIndex() {
        if (!this.hasPrevious()) {
            return -1;
        }
        if (this.goodState) {
            return --this.index;
        }
        this.goodState = true;
        this.index = this.end - this.begin - 1;
        return this.index;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.get(this.nextIndex() + this.begin);
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.get(this.previousIndex() + this.begin);
    }

    @Override
    public void add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E o) {
        if (!this.goodState) {
            throw new IllegalStateException();
        }
        this.set(this.index, o);
    }
}

