/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractIntegerCollection;
import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.IntegerCollections;
import net.morilib.util.primitive.IntegerList;
import net.morilib.util.primitive.IntegerVector;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.iterator.IntegerVectorIterator;

public abstract class AbstractIntegerVector
extends AbstractIntegerCollection
implements IntegerVector,
RandomAccess {
    private static final long serialVersionUID = 3332872309405682099L;
    protected transient int modCount = 0;

    @Override
    public boolean addAllInt(int index, IntegerCollection a) {
        int i2 = index;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        IntegerIterator i = a.intIterator();
        while (i.hasNext()) {
            this.addInt(i2++, i.next());
        }
        return true;
    }

    @Override
    public int first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getInt(0);
    }

    @Override
    public int indexOfInt(int v) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getInt(i) == v) {
                    return i;
                }
                ++i;
            }
        } else {
            IntegerVectorIterator i = this.intVectorIterator();
            int j = 0;
            while (i.hasNext()) {
                if (i.next() == v) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public IntegerList rest() {
        return this.subVector(1, this.size());
    }

    @Override
    public IntegerList rest(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            return IntegerCollections.EMPTY_VECTOR;
        }
        return this.subVector(index, this.size());
    }

    @Override
    public boolean addInt(int v) {
        ++this.modCount;
        this.addInt(this.size(), v);
        return true;
    }

    @Override
    public boolean addAllInt(IntegerCollection a) {
        return this.addAllInt(this.size(), a);
    }

    @Override
    public boolean addAllInt(IntegerCollection ... as) {
        int nsize = 0;
        IntegerCollection[] integerCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IntegerCollection a = integerCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            boolean r = false;
            ++this.modCount;
            IntegerCollection[] integerCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                IntegerCollection a = integerCollectionArray2[n];
                r = this.addAllInt(a) | r;
                ++n;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean addAllInt(Collection<? extends IntegerCollection> as) {
        int nsize = 0;
        for (IntegerCollection integerCollection : as) {
            nsize += integerCollection.size();
        }
        if (nsize > 0) {
            int n;
            boolean bl = false;
            ++this.modCount;
            for (IntegerCollection integerCollection : as) {
                n = this.addAllInt(integerCollection) | n;
            }
            return n != 0;
        }
        return false;
    }

    @Override
    public boolean containsInt(int v) {
        return this.indexOfInt(v) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean addAllInt(int[] a) {
        return this.addAllInt(this.size(), (IntegerCollection)new IntegerArrayVector(a));
    }

    @Override
    public boolean addAllInt(int ptr, int[] a) {
        return this.addAllInt(ptr, (IntegerCollection)new IntegerArrayVector(a));
    }

    @Override
    public IntegerIterator intIterator() {
        return new Itr(null, null);
    }

    @Override
    public boolean removeInt(int v) {
        int ind = this.indexOfInt(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean remove(Object v) {
        int ind = this.indexOf(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> a) {
        ++this.modCount;
        return this.addAll(this.size(), a);
    }

    @Override
    public boolean contains(Object v) {
        return this.indexOf(v) >= 0;
    }

    @Override
    public int lastIndexOfInt(int v) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getInt(i) == v) {
                    return i;
                }
                --i;
            }
        } else {
            IntegerVectorIterator i = this.intVectorIterator();
            while (i.hasNext()) {
                i.next();
            }
            int j = this.size() - 1;
            while (i.hasPrevious()) {
                if (i.previous() == v) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public IntegerVectorIterator intVectorIterator() {
        return this.intVectorIterator(0);
    }

    @Override
    public IntegerVectorIterator intVectorIterator(int index) {
        return new VItr();
    }

    @Override
    public IntegerVector subVector(int start, int end) {
        if (start < 0 || start >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new SubV(this, start, end);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i2 = index;
        ++this.modCount;
        if (c.isEmpty()) {
            return false;
        }
        Iterator<? extends Integer> i = c.iterator();
        while (i.hasNext()) {
            this.add(i2++, i.next());
        }
        return true;
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.setInt(index, element);
    }

    @Override
    public void add(int index, Integer element) {
        this.addInt(index, element);
    }

    @Override
    public Integer remove(int index) {
        return this.removeAt(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Integer) {
            return this.indexOfInt((Integer)o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Integer) {
            return this.lastIndexOfInt((Integer)o);
        }
        return -1;
    }

    @Override
    public ListIterator<Integer> listIterator() {
        final IntegerVectorIterator i = this.intVectorIterator();
        return new ListIterator<Integer>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Integer next() {
                return i.next();
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public Integer previous() {
                return i.previous();
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public void set(Integer e) {
                i.setInt(e);
            }

            @Override
            public void add(Integer e) {
                i.addInt(e);
            }
        };
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return this.listIterator(0);
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        final IntegerVector v = this.subVector(fromIndex, toIndex);
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return (Integer)v.get(index);
            }

            @Override
            public int size() {
                return AbstractIntegerVector.this.size();
            }

            @Override
            public Integer set(int index, Integer element) {
                return v.set(index, element);
            }

            @Override
            public void add(int index, Integer element) {
                v.add(index, element);
            }

            @Override
            public Integer remove(int index) {
                return (Integer)v.remove(index);
            }
        };
    }

    @Override
    public void add(int index, int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.addInt(index, v);
    }

    @Override
    public int set(int index, int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.setInt(index, v);
    }

    @Override
    public int indexOf(int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            return -1;
        }
        return this.indexOfInt(v);
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.toIntArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntegerVector) {
            IntegerVector v = (IntegerVector)obj;
            if (this.size() != v.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (this.getInt(i) != v.getInt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof IntegerList) {
            IntegerIterator i = this.intIterator();
            IntegerIterator j = ((IntegerList)obj).intIterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next() == j.next()) continue;
                return false;
            }
            return !i.hasNext() && !j.hasNext();
        }
        return false;
    }

    private class Itr
    implements IntegerIterator {
        int ptr = 0;
        int ptrrem = -1;
        int exModCount;

        private Itr() {
            this.exModCount = AbstractIntegerVector.this.modCount;
        }

        void checks() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractIntegerVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        void checks2() {
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            if (this.ptrrem >= AbstractIntegerVector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractIntegerVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ptr < AbstractIntegerVector.this.size();
        }

        @Override
        public int next() {
            this.checks();
            this.ptrrem = this.ptr;
            return AbstractIntegerVector.this.getInt(this.ptr++);
        }

        @Override
        public void remove() {
            this.checks2();
            try {
                AbstractIntegerVector.this.removeAt(this.ptrrem);
                this.exModCount = AbstractIntegerVector.this.modCount;
                --this.ptr;
                this.ptrrem = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ Itr(Itr itr, Itr itr2) {
            this();
        }
    }

    private static class SubV
    extends AbstractIntegerVector {
        private IntegerVector vector;
        private int bindex;
        private int eindex;

        private SubV(IntegerVector vector, int b, int e) {
            this.vector = vector;
            this.bindex = b;
            this.eindex = e;
        }

        @Override
        public void addInt(int index, int v) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ++this.eindex;
            this.vector.addInt(index + this.bindex, v);
        }

        @Override
        public int getInt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.getInt(index + this.bindex);
        }

        @Override
        public int removeAt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            --this.eindex;
            return this.vector.removeAt(index + this.bindex);
        }

        @Override
        public int setInt(int index, int v) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.setInt(index + this.bindex, v);
        }

        @Override
        public int size() {
            return this.eindex - this.bindex;
        }
    }

    private class VItr
    extends Itr
    implements IntegerVectorIterator {
        private VItr() {
        }

        @Override
        public void addInt(int v) {
            if (this.exModCount != AbstractIntegerVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                this.ptrrem = -1;
                AbstractIntegerVector.this.addInt(this.ptr++, v);
                this.exModCount = AbstractIntegerVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr > 0;
        }

        @Override
        public int nextIndex() {
            return this.ptr;
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractIntegerVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                int res = AbstractIntegerVector.this.getInt(this.ptr);
                this.ptrrem = --this.ptr;
                return res;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this.ptr - 1;
        }

        @Override
        public void setInt(int v) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            if (this.exModCount != AbstractIntegerVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractIntegerVector.this.setInt(this.ptr, v);
                this.ptrrem = -1;
                this.exModCount = AbstractIntegerVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int v) {
            if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.addInt(v);
        }

        @Override
        public void set(int v) {
            if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.setInt(v);
        }
    }
}

