/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleSet;
import net.morilib.util.primitive.AbstractIntegerCollection;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.IntegerValueMap;
import net.morilib.util.primitive.map.po.DoubleMap;
import net.morilib.util.primitive.map.pp.DoubleIntegerMap;

public abstract class AbstractDoubleIntegerMap
implements DoubleIntegerMap {
    private transient DoubleSet keySet = null;
    private transient IntegerCollection values = null;
    private transient Set<DoubleMap.PrimitiveEntryK<Integer>> entrySetK = null;
    private transient Set<IntegerValueMap.PrimitiveEntryV<Double>> entrySetV = null;
    private transient Set<Map.Entry<Double, Integer>> entrySet = null;

    @Override
    public void clear() {
        Iterator<DoubleIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(int v) {
        for (DoubleIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public int f(double k) {
        for (DoubleIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Integer getElement(double k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet doubleKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(DoubleIntegerMap map) {
        for (DoubleIntegerMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKeyElement((Double)key);
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        if (key instanceof Integer) {
            return this.getElement((Double)key);
        }
        return null;
    }

    @Override
    public Integer put(Double key, int value) {
        return this.putElement((double)key, value);
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof Integer) {
            return this.removeElement((Double)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Integer> m) {
        for (Map.Entry<? extends Double, ? extends Integer> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleSet keySet() {
        return this.doubleKeySet();
    }

    @Override
    public Set<Map.Entry<Double, Integer>> entrySet() {
        final Set<DoubleIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Double, Integer>>(){

                @Override
                public Iterator<Map.Entry<Double, Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Double, Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Double, Integer> next() {
                            final DoubleIntegerMap.PrimitiveEntry o = (DoubleIntegerMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Double, Integer>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(double k) {
        for (DoubleIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer get(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Integer put(int k, Integer v) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((double)k, v);
    }

    @Override
    public Integer removeElement(double k) {
        Iterator<DoubleIntegerMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            DoubleIntegerMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            int r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Integer remove(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<DoubleMap.PrimitiveEntryK<Integer>> doubleKeyEntrySet() {
        final Set<DoubleIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<DoubleMap.PrimitiveEntryK<Integer>>(){

                @Override
                public Iterator<DoubleMap.PrimitiveEntryK<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleMap.PrimitiveEntryK<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleMap.PrimitiveEntryK<Integer> next() {
                            final DoubleIntegerMap.PrimitiveEntry o = (DoubleIntegerMap.PrimitiveEntry)i.next();
                            return new DoubleMap.PrimitiveEntryK<Integer>(){

                                @Override
                                public double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Integer getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Integer setValue(Integer value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Integer putElement(double k, Integer v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleMap<Integer> map) {
        for (DoubleMap.PrimitiveEntryK<Integer> e : map.doubleKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<IntegerValueMap.PrimitiveEntryV<Double>> intValueEntrySet() {
        final Set<DoubleIntegerMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<IntegerValueMap.PrimitiveEntryV<Double>>(){

                @Override
                public Iterator<IntegerValueMap.PrimitiveEntryV<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerValueMap.PrimitiveEntryV<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerValueMap.PrimitiveEntryV<Double> next() {
                            final DoubleIntegerMap.PrimitiveEntry o = (DoubleIntegerMap.PrimitiveEntry)i.next();
                            return new IntegerValueMap.PrimitiveEntryV<Double>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public int getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public int setValue(int value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public int getElement(Object k) {
        if (k instanceof Double) {
            return this.f((Double)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int putElement(Double k, int v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerValueMap<Double> map) {
        for (IntegerValueMap.PrimitiveEntryV<Double> e : map.intValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerCollection intValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            return this.containsValueElement((Integer)value);
        }
        return false;
    }

    @Override
    public Integer put(Double key, Integer value) {
        return this.putElement((double)key, (int)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (DoubleIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof DoubleIntegerMap)) break block1;
            m = (DoubleIntegerMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (DoubleIntegerMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractDoubleSet {
        private Set<DoubleIntegerMap.PrimitiveEntry> eset;

        private KSet(Set<DoubleIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<DoubleIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public double next() {
                    return ((DoubleIntegerMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleIntegerMap.this.size();
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractDoubleIntegerMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleIntegerMap.this.clear();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractIntegerCollection {
        private Set<DoubleIntegerMap.PrimitiveEntry> eset;

        private VCol(Set<DoubleIntegerMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<DoubleIntegerMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public int next() {
                    return ((DoubleIntegerMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleIntegerMap.this.size();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractDoubleIntegerMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleIntegerMap.this.clear();
        }
    }
}

