  (define (eval-error exp) #f)

  (define (geta l)
    (car l))
  (define (getd l)
    (cdr l))
  (define (geta2 l)
    (if (pair? l) (car l) #f))
  (define (getd2 l)
    (if (pair? l) (cdr l) #f))
  (define (getad   l) (geta   (getd l)))
  (define (getadd  l) (getad  (getd l)))
  (define (getaddd l) (getadd (getd l)))

  (define (nthd exp n)
    (if (= n 1) exp (nthd (getd exp) (- n 1))))
  (define (ntha exp n)
    (if (= n 1) (geta exp) (ntha (getd exp) (- n 1))))

  (define (listf . exp)
    (cond ((null? exp) '())
          ((car exp) (cons (car exp) (apply listf (cdr exp))))
          (else (apply listf (cdr exp)))))

  (define-syntax lisql$evn
    (syntax-rules ()
      ((_ evals exp env rd opt)
       (if (null? (nthd exp rd))
           (if opt '() (eval-error exp))
           (let ((r (evals (ntha exp rd) env)))
             (if r (set! rd (+ rd 1)))
             r)))))

  (define (eval-select exp env)
    (let ((g (geta exp)))
      (cond ((eq? g 'select) (eval-select1 (getd exp) env))
            ((eq? g 'union) (eval-union (getd exp) env))
            ((eq? g 'intersect) (eval-intersect (getd exp) env))
            ((eq? g 'except) (eval-except (getd exp) env))
            ((eq? g 'union-all) (eval-union-all (getd exp) env))
            ((eq? g 'intersect-all) (eval-intersect-all (getd exp) env))
            ((eq? g 'except-all) (eval-except-all (getd exp) env))
            (else (eval-error exp)))))

  (define (list->ii exp env proc op)
    (cond ((null? exp) (eval-error exp))
           ((null? (cdr exp)) (list (proc (car exp) env)))
           (else (cons (proc (car exp) env)
                    (cons op (list->ii (cdr exp) env proc op))))))

  (define (eval-symbol1 exp env)
    (if (symbol? exp) (symbol->string exp) (eval-error exp)))

  (define (eval-setop exp env op) (list->ii exp env eval-select op))
  (define (eval-union exp env) (eval-setop exp env "UNION "))
  (define (eval-union-all exp env) (eval-setop exp env "UNION ALL "))
  (define (eval-intersect exp env) (eval-setop exp env "INTERSECT "))
  (define (eval-intersect-all exp env)
    (eval-setop exp env "INTERSECT ALL "))
  (define (eval-except exp env) (eval-setop exp env "EXCEPT "))
  (define (eval-except-all exp env) (eval-setop exp env "EXCEPT ALL "))

  (define (eval-select1 exp env)
    (let ((rd 1))
      (listf
        "SELECT "
        (lisql$evn eval-cols exp env rd #f) " "
        (lisql$evn eval-from exp env rd #f) " "
        (lisql$evn eval-where exp env rd #t) " "
        (lisql$evn eval-group-by exp env rd #t) " "
        (lisql$evn eval-having exp env rd #t) " "
        (lisql$evn eval-order-by exp env rd #t))))

  (define (eval-from exp env)
    (if (eq? (geta exp) 'from)
        (list " FROM " (eval-tables (getd exp) env))
        #f))
  (define (eval-where exp env)
    (if (eq? (geta exp) 'where)
        (list " WHERE " (eval-relop (getad exp) env))
        #f))
  (define (eval-having exp env)
    (if (eq? (geta exp) 'having)
        (list " HAVING " (eval-relop (getad exp) env))
        #f))
  (define (eval-group-by exp env)
    (if (eq? (geta exp) 'group-by)
        (list " GROUP BY "
              (list->ii exp env (lambda (exp env) (getd exp)) ","))
        #f))
  (define (eval-order-by exp env)
    (if (eq? (geta exp) 'group-by)
        (list " ORDER BY "
              (list->ii exp env (lambda (exp env) (getd exp)) ","))
        #f))

  (define (eval-cols exp env)
    (list->ii exp env (lambda (exp env) exp) ","))

  (define (eval-tables exp env)
    (list->ii exp env eval-table-join ","))
  (define (eval-table-join exp env)
    (let ((r (geta2 exp)))
      (cond ((or (eq? r 'join) (eq? r 'inner-join))
              (eval-inner-join (getd exp) env))
            ((eq? r 'left-outer-join)
              (eval-left-outer-join (getd exp) env))
            ((eq? r 'right-outer-join)
              (eval-left-outer-join (getd exp) env))
            ((eq? r 'full-outer-join)
              (eval-full-outer-join (getd exp) env))
            ((eq? r 'natural-join)
              (eval-natural-join (getd exp) env))
            ((or (not r) (eq? r 'as)) (eval-table1 exp env))
            (else (eval-error exp)))))

  (define (eval-join exp env op)
    (list->ii exp env eval-table1-on op))
  (define (eval-join2 exp env op)
    (list->ii exp env eval-table1 op))
  (define (eval-table1-on exp env)
    (cond ((eq? (geta2 exp) 'on)
            (list (eval-table1 (getad  exp) env)
                  " ON "
                  (eval-relop  (getadd exp) env)))
          (else (eval-table1 exp env))))

  (define (eval-inner-join exp env)
    (eval-join exp env " INNER JOIN "))
  (define (eval-left-outer-join exp env)
    (eval-join exp env " LEFT OUTER JOIN "))
  (define (eval-right-outer-join exp env)
    (eval-join exp env " RIGHT OUTER JOIN "))
  (define (eval-full-outer-join exp env)
    (eval-join exp env " FULL OUTER JOIN "))
  (define (eval-natural-join exp env)
    (eval-join2 exp env " NATURAL JOIN "))

  (define (eval-tables-list exp env)
    (list->ii exp env eval-table1 ","))

  (define (eval-table1 exp env)
    (cond ((symbol? exp) (symbol->string exp))
          ((eq? (geta exp) 'as) (eval-table-as (getd exp) env))
          (else (eval-error exp))))

  (define (eval-table-as exp env)
    (let ((r (eval-select (geta exp) env)))
      (cond (r (list "(" r ") AS " (symbol->string (geta (getd exp)))))
            ((symbol? (geta exp))
              (list (symbol->string (geta exp))
                    " AS "
                    (symbol->string (geta (getd exp)))))
            (else (eval-error exp)))))

  (define (eval-relop exp env)
    (let ((r (geta exp)))
      (cond ((eq? r 'and) `("(" ,@(eval-and (getd exp) env) ")"))
            ((eq? r 'or) `("(" ,@(eval-or (getd exp) env) ")"))
            ((eq? r 'not) `("(" ,@(eval-not (getad exp) env) ")"))
            (else (eval-relop1
                    (geta exp) (getad exp) (getadd exp) env)))))

  (define (eval-and exp env)
    (list->ii exp env eval-relop " AND "))
  (define (eval-or exp env)
    (list->ii exp env eval-relop " OR "))
  (define (eval-not exp env)
    (list " NOT " (eval-relop exp env)))

  (define (eval-relop1 op e1 e2 env)
    `(,(eval-scalar0 e1 env)
      ,(symbol->string op) " "
      ,(eval-scalar0 e2 env)))
  (define (eval-scalar0 exp env)
    (if (keyword? exp) "? " (eval-scalar exp env)))

  (define (eval-scalar exp env)
    (cond ((and (pair? exp) (eq? (geta exp) 'select))
            `("(" ,(eval-select1 (getd exp) env) ")"))
          ((pair? exp) (apply-func (geta exp) (getd exp) env))
          ((null? exp) (eval-error exp))
          (else exp)))

  (define (apply-func fn exp env)
    (let ((r (assq fn sclenv)))
      (if r ((cdr r) exp env)
            (apply-default-func fn exp env))))
  (define (apply-default-func fn exp env)
    `(,(symbol->string fn)
      "(" ,@(list->ii exp env eval-scalar ",") ")"))

  (define (eval+ exp env)
    (cond ((null? exp) 0)
          ((and (pair? exp) (null? (cdr exp))) (car exp))
          (else `("(" ,@(list->ii exp env eval-scalar " + ") ")"))))
  (define (eval* exp env)
    (cond ((null? exp) 1)
          ((and (pair? exp) (null? (cdr exp))) (car exp))
          (else `("(" ,@(list->ii exp env eval-scalar " * ") ")"))))
  (define (eval- exp env)
    (cond ((null? exp) (eval-error env))
          ((and (pair? exp) (null? (cdr exp))) (list "-" (car exp)))
          (else `("(" ,@(list->ii exp env eval-scalar " - ") ")"))))
  (define (eval/ exp env)
    (cond ((null? exp) (eval-error env))
          ((and (pair? exp) (null? (cdr exp))) (list "1/" (car exp)))
          (else `("(" ,@(list->ii exp env eval-scalar " / ") ")"))))
  (define (eval& exp env)
    (cond ((null? exp) "''")
          ((and (pair? exp) (null? (cdr exp))) (car exp))
          (else `("(" ,@(list->ii exp env eval-scalar "||") ")"))))

  (define sclenv
    `((+  . ,eval+)
      (-  . ,eval-)
      (*  . ,eval*)
      (/  . ,eval/)
      (&  . ,eval&)))

;; END

