/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.net.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Undef;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.util.IOs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/01/14
 */
public class FtpPut extends BinaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Datum c2a, Environment env,
			LispMessage mesg) {
		InputStream in = null;
		File fn;

		if(!(c1a instanceof LispFTPConnection)) {
			throw mesg.getError("err.net.require.ftpconnection", c1a);
		} else if(c2a instanceof LispString) {
			try {
				fn = LispFiles.getFile(env, c2a, mesg);
				in = new FileInputStream(fn);
				((LispFTPConnection)c1a).client.put(fn.toString(), in);
				return Undef.UNDEF;
			} catch (IOException e) {
				throw mesg.getError("err.io", e.getMessage());
			} finally {
				IOs.close(in);
			}
		} else {
			throw mesg.getError("err.require.string", c2a);
		}
	}

}
