/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.datetime;

import java.util.List;

import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispSmallInt;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Subr;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/01/09
 */
public class MakeDate extends Subr {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	public Datum eval(Datum body, Environment env, LispMessage mesg) {
		List<Datum> l = LispUtils.consToList(body, mesg);

		if(l.size() != 8) {
			throw mesg.getError("err.argument", body);
		} else if(!(l.get(0) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(0));
		} else if(!(l.get(1) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(1));
		} else if(!(l.get(2) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(2));
		} else if(!(l.get(3) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(3));
		} else if(!(l.get(4) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(4));
		} else if(!(l.get(5) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(5));
		} else if(!(l.get(6) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(6));
		} else if(!(l.get(7) instanceof LispSmallInt)) {
			throw mesg.getError("err.require.smallint", l.get(7));
		}

		return new LispDate(
				l.get(0).getInt(),
				l.get(1).getInt(),
				l.get(2).getInt(),
				l.get(3).getInt(),
				l.get(4).getInt(),
				l.get(5).getInt(),
				l.get(6).getInt(),
				l.get(7).getInt());
	}

}
