# -*- coding: utf-8 -*-

# GUIのメインフレームにおけるお守り検索Notebookのview
# 2013/12/15 written by kei9
import wx
from wx import xrc
import wx.grid

import constnumbers

class NoteBookAmuletView():
    u""" メインのフレームのお守り検索タブ """
    def __init__(self, frame):
        self.frame = frame
        self._init_view()

    def _init_view(self):
        # initialize view

        # button
        self.button_search = xrc.XRCCTRL(self.frame, "ButtonAmuletSearchSearch")
        self.button_clear = xrc.XRCCTRL(self.frame, "ButtonAmuletSearchClear")
        self.button_skill = xrc.XRCCTRL(self.frame, "ButtonAmuletSearchSkill")
        self.ID_BUTTON_SEARCH = xrc.XRCID("ButtonAmuletSearchSearch")
        self.ID_BUTTON_CLEAR = xrc.XRCID("ButtonAmuletSearchClear")
        self.ID_BUTTON_SKILL = xrc.XRCID("ButtonAmuletSearchSkill")

        # radio button
        self.radiobox_amulet = xrc.XRCCTRL(self.frame, "RadioBoxAmulet")
        self.radiobox_threshold_type = xrc.XRCCTRL(self.frame, "RadioBoxThresholdType")

        # seed list
        self.list_box_seeds = xrc.XRCCTRL(self.frame, "ListBoxAmuletSearchSeeds")
        self.ID_LIST_BOX_SEEDS = xrc.XRCID("ListBoxAmuletSearchSeeds")

        # spin ctrl
        self.spin_ctrl_skill1_val = xrc.XRCCTRL(self.frame, "SpinCtrlAmuletSearchSkill1Value")
        self.spin_ctrl_skill2_val = xrc.XRCCTRL(self.frame, "SpinCtrlAmuletSearchSkill2Value")
        self.spin_ctrl_slot_num = xrc.XRCCTRL(self.frame, "SpinCtrlAmuletSearchSlotNumber")
        self.ID_SPIN_CTRL_SKILL1_VAL = xrc.XRCID("SpinCtrlAmuletSearchSkill1Value")
        self.ID_SPIN_CTRL_SKILL2_VAL = xrc.XRCID("SpinCtrlAmuletSearchSkill2Value")

        # combobox
        self.combo_box_skill1 = xrc.XRCCTRL(self.frame, "ComboBoxAmuletSearchSkill1")
        self.combo_box_skill2 = xrc.XRCCTRL(self.frame, "ComboBoxAmuletSearchSkill2")
        self.ID_COMBO_BOX_SKILL1 = xrc.XRCID("ComboBoxAmuletSearchSkill1")
        self.ID_COMBO_BOX_SKILL2 = xrc.XRCID("ComboBoxAmuletSearchSkill2")

        # text ctrl
        self.text_ctrl_result = xrc.XRCCTRL(self.frame, "TextCtrlAmuletSearchResult")

        # set min & max of slot
        self.set_slot_minmax(constnumbers.SLOT_MIN, constnumbers.SLOT_MAX)

    def bind_radiobox_amulet(self, event_func, evt=wx.EVT_RADIOBOX):
        u""" お守り種類のラジオボタンが押された時のイベントをセットする """
        self.radiobox_amulet.Bind(evt, event_func)

    def bind_radiobox_threshold_type(self, event_func, evt=wx.EVT_RADIOBOX):
        u""" 判定値の種類のラジオボタンが押された時のイベントをセットする """
        self.radiobox_threshold_type.Bind(evt, event_func)

    def bind_combobox(self, event_func, evt=wx.EVT_COMBOBOX):
        u""" コンボボタンが押された時のイベントをセットする """
        self.combo_box_skill1.Bind(evt, event_func)
        self.combo_box_skill2.Bind(evt, event_func)

    def bind_button_search(self, event_func, evt=wx.EVT_BUTTON):
        u""" 検索ボタンが押された時のイベントをセットする """
        self.button_search.Bind(evt, event_func)

    def bind_button_clear(self, event_func, evt=wx.EVT_BUTTON):
        u""" クリアボタンが押された時のイベントをセットする """
        self.button_clear.Bind(evt, event_func)

    def bind_button_skill(self, event_func, evt=wx.EVT_BUTTON):
        u""" スキル検索ボタンが押された時のイベントをセットする """
        self.button_skill.Bind(evt, event_func)

    def set_skill_minmax(self, min1, max1, min2, max2):
        u""" 第1,2スキルの最大値と最小値をセットする """
        self.spin_ctrl_skill1_val.SetRange(min1, max1)
        self.spin_ctrl_skill2_val.SetRange(min2, max2)

    def set_slot_minmax(self, slot_min, slot_max):
        u""" スロットの最大値と最小値をセットする """
        self.spin_ctrl_slot_num.SetRange(slot_min, slot_max)

    def get_skill_values(self):
        u""" 第1,2スキルの値を得る 
        return (skill1_val, skill2_val)"""
        skill1_val = self.spin_ctrl_skill1_val.GetValue()
        skill2_val = self.spin_ctrl_skill2_val.GetValue()
        return (skill1_val, skill2_val)

    def get_slot_value(self):
        u""" スロットの値を得る """
        return self.spin_ctrl_slot_num.GetValue()

    def set_radio_value(self, value, amulet_name=constnumbers.NAME_AMULET1):
        u""" ラジオボタンの値をセットする 
            arg: (value, amulet_name)
        """
        if amulet_name == constnumbers.NAME_AMULET1:
            idx = 0
        elif amulet_name == constnumbers.NAME_AMULET2:
            idx = 1
        elif amulet_name == constnumbers.NAME_AMULET3:
            idx = 2
        self.radiobox_amulet.SetSelection(idx)

    def get_radio_value(self, amulet_name=constnumbers.NAME_AMULET1):
        u""" ラジオボタンの値を得る
            return: (value)
        """
        if amulet_name == constnumbers.NAME_AMULET1:
            idx = 0
        elif amulet_name == constnumbers.NAME_AMULET2:
            idx = 1
        elif amulet_name == constnumbers.NAME_AMULET3:
            idx = 2
        return self.radiobox_amulet.GetSelection() == idx

    def get_selected_amulet(self):
        u""" 選択されているお守り名を得る 
            return: (NAME_OF_AMULET)
        """
        idx = self.radiobox_amulet.GetSelection()
        if idx == 0:
            return constnumbers.NAME_AMULET1
        elif idx == 1:
            return constnumbers.NAME_AMULET2
        elif idx == 2:
            return constnumbers.NAME_AMULET3
        else:
            raise NotImplementedError("irregular radio button selected")

    def get_selected_threshold_type(self):
        u""" 選択されているラジオボタンの検索種類IDを得る
            return: (THRESHOLD_TYPE_ID)
        """
        idx = self.radiobox_threshold_type.GetSelection()
        if idx == 0:
            return constnumbers.THRESHOLD_TYPE_ALL
        elif idx == 1:
            return constnumbers.THRESHOLD_TYPE_THRESHOLD1
        elif idx == 2:
            return constnumbers.THRESHOLD_TYPE_THRESHOLD2
        elif idx == 3:
            return constnumbers.THRESHOLD_TYPE_INISHIE
        else:
            raise NotImplementedError("irregular radio button selected")

    def set_selection_skill1_combobox(self, idx):
        u""" skill1のコンボボックスの選択されたインデックスをセットする """
        self.combo_box_skill1.SetSelection(idx)

    def set_selection_skill2_combobox(self, idx):
        u""" skill2のコンボボックスの選択されたインデックスをセットする """
        self.combo_box_skill2.SetSelection(idx)

    def get_string_selection_skill1_combobox(self):
        u""" skill1のコンボボックスの選択された値を得る """
        return self.combo_box_skill1.GetStringSelection()

    def get_string_selection_skill2_combobox(self):
        u""" skill2のコンボボックスの選択された値を得る """
        return self.combo_box_skill2.GetStringSelection()

    def get_string_selection_skill_names(self):
        u""" skill1, skill2で選択されているスキル名を返す
            return (skill1_name, skill2_name)"""
        skill1_name = self.get_string_selection_skill1_combobox()
        skill2_name = self.get_string_selection_skill2_combobox()
        return (skill1_name, skill2_name)

    def set_items_skill1_combobox(self, string_list):
        u""" skill1のコンボボックスの値をセットする """
        self.combo_box_skill1.SetItems(string_list)

    def set_items_skill2_combobox(self, string_list):
        u""" skill2のコンボボックスの値をセットする """
        self.combo_box_skill2.SetItems(string_list)

    def set_items_skill_combobox(self, idx, string_list):
        u""" 指定されたインデックスのskillのコンボボックスの値をセットする """
        if idx == 0:
            self.set_items_skill1_combobox(string_list)
        elif idx == 1:
            self.set_items_skill2_combobox(string_list)
        else:
            raise NotImplementedError(u"this idx is not implemented")

    def set_skill_button_enable(self, value):
        u""" 対応スキル検索ボタンの有効・無効の切り替え """
        if value is True:
            self.button_skill.Enable()
        else:
            self.button_skill.Disable()

    def set_result_text_ctrl_value(self, value):
        u""" 結果表示用のTextCtrlに値をセットする """
        self.text_ctrl_result.SetValue(value)

    def set_listbox_items(self, items):
        u""" Seed一覧のListBoxに値をセットする。
        Noneが与えられた時はClearする"""
        if items is not None:
            self.list_box_seeds.SetItems(items)
        else:
            self.list_box_seeds.Clear()

    def get_string_selection_listbox(self):
        u""" Seed一覧のListBoxの選択された値を得る。"""
        return self.list_box_seeds.GetStringSelection()

    def set_selection_listbox(self, idx):
        u""" Seed一覧のListBoxの選択されたインデックスをセットする。"""
        self.list_box_seeds.SetSelection(idx)

    def clear_listbox_items(self):
        u""" Seed一覧のListBoxから値をClearする"""
        self.list_box_seeds.Clear()
