# -*- coding: utf-8 -*-

# GUIのメインフレームにおけるSkill2一覧Notebookのview
# 2013/12/15 written by kei9
import wx
from wx import xrc
import wx.grid

import constnumbers

class NoteBookSkill2View():
    u""" メインのフレームのスキル2一覧タブ """
    def __init__(self, frame):
        self.frame = frame
        self._init_view()

    def _init_view(self):
        # initialize view
        self.skill2_grid = xrc.XRCCTRL(self.frame, "GridSecondSkill")
        self.ID_SKILL2_GRID = xrc.XRCID("GridSecondSkill")
        self.skill2_grid.Bind(wx.EVT_SIZE, self.OnSkill2GridSize)

        self.button_skill2_search = xrc.XRCCTRL(self.frame, "ButtonSeedSkillSearch")
        self.button_skill2_clear = xrc.XRCCTRL(self.frame, "ButtonSeedSkillClear")
        self.ID_BUTTON_SKILL2_SEARCH = xrc.XRCID("ButtonSeedSkillSearch")
        self.ID_BUTTON_SKILL2_CLEAR = xrc.XRCID("ButtonSeedSkillClear")

        # load skill2 grid value
        self.skill2_grid.CreateGrid(constnumbers.NUM_SKILL2_GRID_ROW, constnumbers.NUM_SKILL2_GRID_COL)
        self.skill2_grid.SetColLabelValue(0, constnumbers.NAME_AMULET1)
        self.skill2_grid.SetColLabelValue(1, constnumbers.NAME_AMULET2)
        self.skill2_grid.SetColLabelValue(2, constnumbers.NAME_AMULET3)
        self.skill2_grid.SetColLabelValue(3, constnumbers.NAME_THRESHOLD1)
        self.skill2_grid.SetColLabelValue(4, constnumbers.NAME_THRESHOLD2)
        for i in range(constnumbers.NUM_SKILL2_GRID_ROW):
            self.skill2_grid.SetRowLabelValue(i, constnumbers.LABEL_FORMAT_SKILL2_GRID_ROW.format(i+1))
        self.skill2_grid.DisableDragGridSize()
        self.skill2_grid.EnableEditing(False)

        # text ctrl
        self.text_ctrl_seed2_select = xrc.XRCCTRL(self.frame, "TextCtrlSeedSelect")
        self.text_ctrl_result = xrc.XRCCTRL(self.frame, "TextCtrlSkillResult")
        self.text_ctrl_inishie_skill2 = xrc.XRCCTRL(self.frame, "TextCtrlInishieSkill")
        self.text_ctrl_inishie_threshold1 = xrc.XRCCTRL(self.frame, "TextCtrlInishieThreshold1")
        self.text_ctrl_inishie_threshold2 = xrc.XRCCTRL(self.frame, "TextCtrlInishieThreshold2")

        self.list_box_amulet_prospect = xrc.XRCCTRL(self.frame, "ListBoxSeedSkillAmuletProspect")
        self.ID_LIST_BOX_AMULET_PROSPECT = xrc.XRCID("ListBoxSeedSkillAmuletProspect")

    def OnSkill2GridSize(self, event):
        u""" Gridリサイズ時に親パネルのwidthに応じて自動で横に伸長する """
        width, height = self.skill2_grid.GetParent().GetSize()
        each_width = (width - 50) / (constnumbers.NUM_SKILL2_GRID_COL) # consider margin size
        self.skill2_grid.SetRowLabelSize(40)
        for col in range(constnumbers.NUM_SKILL2_GRID_COL):
            self.skill2_grid.SetColSize(col, each_width)

    def bind_button_search(self, event_func, evt=wx.EVT_BUTTON):
        u""" 検索ボタンへのイベント登録 """
        self.button_skill2_search.Bind(evt, event_func)

    def bind_button_clear(self, event_func, evt=wx.EVT_BUTTON):
        u""" クリアボタンへのイベント登録 """
        self.button_skill2_clear.Bind(evt, event_func)

    def set_skill2_highlight(self, skill_names, threshold1, threshold2, color="Yellow"):
        u""" スキル名、判定値1,2での条件を満たすセルをハイライトする """
        skill_cols = [constnumbers.DICT_SKILL2_GRID_COL[x]
                for x in [constnumbers.KEY_AMULET1, constnumbers.KEY_AMULET2, constnumbers.KEY_AMULET3]]
        for row in range(constnumbers.NUM_SKILL2_GRID_ROW):
            for col in skill_cols:
                val = self.skill2_grid.GetCellValue(row, col)
                if val in skill_names:
                    self.skill2_grid.SetCellBackgroundColour(row, col, color)
                else:
                    self.skill2_grid.SetCellBackgroundColour(row, col, wx.NullColor)

        # threshold
        th_cols = [constnumbers.DICT_SKILL2_GRID_COL[x]
                for x in [constnumbers.KEY_THRESHOLD1, constnumbers.KEY_THRESHOLD2]]
        th_vals = [threshold1, threshold2]
        for row in range(constnumbers.NUM_SKILL2_GRID_ROW):
            for col, th_val in zip(th_cols, th_vals):
                val = self.skill2_grid.GetCellValue(row, col)
                if val.isdigit() and int(val) >= th_val:
                    self.skill2_grid.SetCellBackgroundColour(row, col, color)
                else:
                    self.skill2_grid.SetCellBackgroundColour(row, col, wx.NullColor)
        self._set_inishie_highlight(skill_names, threshold1, threshold2, color)

    def _set_inishie_highlight(self, skill_names, threshold1, threshold2, color="Yellow"):
        u"""いにしえの錬金結果のハイライト"""
        val = self.text_ctrl_inishie_skill2.GetValue()
        if val in skill_names:
            self.text_ctrl_inishie_skill2.SetBackgroundColour(color)
        else:
            self.text_ctrl_inishie_skill2.SetBackgroundColour(wx.NullColor)

        for txt_ctrl, th_val in zip([self.text_ctrl_inishie_threshold1, self.text_ctrl_inishie_threshold2],
                [threshold1, threshold2]):
            val = txt_ctrl.GetValue()
            if val.isdigit() and int(val) >= th_val:
                txt_ctrl.SetBackgroundColour(color)
            else:
                txt_ctrl.SetBackgroundColour(wx.NullColor)

    def clear_skill2_highlight(self):
        u""" 表のハイライトをクリアする """
        for row in range(constnumbers.NUM_SKILL2_GRID_ROW):
            for col in range(constnumbers.NUM_SKILL2_GRID_COL):
               self.skill2_grid.SetCellBackgroundColour(row, col, wx.NullColor)
        self.text_ctrl_inishie_skill2.SetBackgroundColour(wx.NullColor)
        self.text_ctrl_inishie_threshold1.SetBackgroundColour(wx.NullColor)
        self.text_ctrl_inishie_threshold2.SetBackgroundColour(wx.NullColor)

    def clear_skill2_grid(self):
        u""" セルの内容をクリアする """
        for row in range(constnumbers.NUM_SKILL2_GRID_ROW):
            for col in range(constnumbers.NUM_SKILL2_GRID_COL):
               self.skill2_grid.SetCellValue(row, col, u"")

    def set_result_text(self, value):
        u""" 結果の表示TextCtrlのセット """
        self.text_ctrl_result.SetValue(value)

    def clear_result_text(self):
        u""" 結果の表示TextCtrlのクリア """
        self.text_ctrl_result.SetValue(u"")

    def set_skill2_by_col_key(self, column_key, values):
        u""" キーに対応する行に値をまとめて登録する """
        col = constnumbers.DICT_SKILL2_GRID_COL[column_key]
        for row, val in zip( range(constnumbers.NUM_SKILL2_GRID_ROW), values):
            self.skill2_grid.SetCellValue(row, col, val)

    def set_seed2_value(self, value):
        u""" TextCtrlに与えられた値をセットする"""
        self.text_ctrl_seed2_select.SetValue(u"{0}".format(value))

    def get_seed2_value(self):
        u""" TextCtrlから入力されたSeed2の値を得る。数値に変換できない時はNoneを返す"""
        seed = self.text_ctrl_seed2_select.GetValue()
        if seed.isdigit():
            return int(seed)
        else:
            return None

    def set_items_amulet_prospects(self, items):
        u""" お守り予測リストにアイテムをセットする """
        self.list_box_amulet_prospect.SetItems(items)

    def clear_items_amulet_prospects(self):
        u""" お守り予測リストからアイテムをクリアする """
        self.list_box_amulet_prospect.Clear()

    def clear_inishie(self):
        u""" いにしえの錬金の結果のクリア """
        self.text_ctrl_inishie_skill2.SetValue(u"")
        self.text_ctrl_inishie_threshold1.SetValue(u"")
        self.text_ctrl_inishie_threshold2.SetValue(u"")

    def set_inishie(self, skill_name, threshold1, threshold2):
        u""" いにしえの錬金の対応する値のセット """
        self.text_ctrl_inishie_skill2.SetValue(u"{0}".format(skill_name))
        self.text_ctrl_inishie_threshold1.SetValue(u"{0}".format(threshold1))
        self.text_ctrl_inishie_threshold2.SetValue(u"{0}".format(threshold2))
