/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class Concat
extends Task {
    private static final int BUFFER_SIZE = 8192;
    private File destinationFile = null;
    private boolean append = false;
    private String encoding = null;
    private String outputEncoding = null;
    private boolean binary = false;
    private StringBuffer textBuffer;
    private Vector sources = new Vector();
    private Vector filterChains = null;
    private boolean forceOverwrite = true;
    private TextElement footer;
    private TextElement header;
    private boolean fixLastLine = false;
    private String eolString = System.getProperty("line.separator");
    private Writer outputWriter = null;
    private Vector sourceFiles = new Vector();
    private static FileUtils fileUtils = FileUtils.newFileUtils();

    public void setDestfile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        if (this.outputEncoding == null) {
            this.outputEncoding = encoding;
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setForce(boolean force) {
        this.forceOverwrite = force;
    }

    public Path createPath() {
        Path path = new Path(this.getProject());
        this.sources.addElement(path);
        return path;
    }

    public void addFileset(FileSet set) {
        this.sources.addElement(set);
    }

    public void addFilelist(FileList list) {
        this.sources.addElement(list);
    }

    public void addFilterChain(FilterChain filterChain) {
        if (this.filterChains == null) {
            this.filterChains = new Vector();
        }
        this.filterChains.addElement(filterChain);
    }

    public void addText(String text) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(text.length());
        }
        this.textBuffer.append(text);
    }

    public void addHeader(TextElement header) {
        this.header = header;
    }

    public void addFooter(TextElement footer) {
        this.footer = footer;
    }

    public void setFixLastLine(boolean fixLastLine) {
        this.fixLastLine = fixLastLine;
    }

    public void setEol(FixCRLF.CrLf crlf) {
        String s = crlf.getValue();
        if (s.equals("cr") || s.equals("mac")) {
            this.eolString = "\r";
        } else if (s.equals("lf") || s.equals("unix")) {
            this.eolString = "\n";
        } else if (s.equals("crlf") || s.equals("dos")) {
            this.eolString = "\r\n";
        }
    }

    public void setWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    private void checkAndExecute() {
        this.sanitizeText();
        if (this.binary) {
            if (this.destinationFile == null) {
                throw new BuildException("DestFile attribute is required for binary concatenation");
            }
            if (this.textBuffer != null) {
                throw new BuildException("Nested text is incompatible with binary concatenation");
            }
            if (this.encoding != null || this.outputEncoding != null) {
                throw new BuildException("Seting input or output encoding is incompatible with binary concatenation");
            }
            if (this.filterChains != null) {
                throw new BuildException("Setting filters is incompatible with binary concatenation");
            }
            if (this.fixLastLine) {
                throw new BuildException("Setting fixlastline is incompatible with binary concatenation");
            }
            if (this.header != null || this.footer != null) {
                throw new BuildException("Nested header or footer is incompatible with binary concatenation");
            }
        }
        if (this.destinationFile != null && this.outputWriter != null) {
            throw new BuildException("Cannot specify both a destination file and an output writer");
        }
        if (this.sources.size() == 0 && this.textBuffer == null) {
            throw new BuildException("At least one file must be provided, or some text.");
        }
        if (this.sources.size() > 0 && this.textBuffer != null) {
            throw new BuildException("Cannot include inline text when using filesets.");
        }
        Enumeration e = this.sources.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Path) {
                Path path = (Path)o;
                this.checkAddFiles(null, path.list());
                continue;
            }
            if (o instanceof FileSet) {
                FileSet fileSet = (FileSet)o;
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                this.checkAddFiles(fileSet.getDir(this.getProject()), scanner.getIncludedFiles());
                continue;
            }
            if (!(o instanceof FileList)) continue;
            FileList fileList = (FileList)o;
            this.checkAddFiles(fileList.getDir(this.getProject()), fileList.getFiles(this.getProject()));
        }
        if (this.destinationFile != null && !this.forceOverwrite && this.sourceFiles.size() > 0 && this.destinationFile.exists()) {
            boolean outofdate = false;
            for (int i = 0; i < this.sourceFiles.size(); ++i) {
                File file = (File)this.sourceFiles.elementAt(i);
                if (file.lastModified() <= this.destinationFile.lastModified()) continue;
                outofdate = true;
                break;
            }
            if (!outofdate) {
                this.log(this.destinationFile + " is up-to-date.", 3);
                return;
            }
        }
        if (this.textBuffer == null && this.sourceFiles.size() == 0 && this.header == null && this.footer == null) {
            this.log("No existing files and no nested text, doing nothing", 2);
            return;
        }
        if (this.binary) {
            this.binaryCat();
        } else {
            this.cat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.checkAndExecute();
        }
        finally {
            this.resetTask();
        }
    }

    public void reset() {
        this.append = false;
        this.forceOverwrite = true;
        this.destinationFile = null;
        this.encoding = null;
        this.outputEncoding = null;
        this.fixLastLine = false;
        this.sources.removeAllElements();
        this.sourceFiles.removeAllElements();
        this.filterChains = null;
        this.footer = null;
        this.header = null;
    }

    private void resetTask() {
        this.sourceFiles.clear();
    }

    private void checkAddFiles(File base, String[] filenames) {
        for (int i = 0; i < filenames.length; ++i) {
            File file = new File(base, filenames[i]);
            if (!file.exists()) {
                this.log("File " + file + " does not exist.", 0);
                continue;
            }
            if (this.destinationFile != null && fileUtils.fileNameEquals(this.destinationFile, file)) {
                throw new BuildException("Input file \"" + file + "\" " + "is the same as the output file.");
            }
            this.sourceFiles.addElement(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void binaryCat() {
        this.log("Binary concatenation of " + this.sourceFiles.size() + " files to " + this.destinationFile);
        FileOutputStream out = null;
        FileInputStream in = null;
        byte[] buffer = new byte[8192];
        try {
            try {
                out = new FileOutputStream(this.destinationFile);
            }
            catch (Exception t) {
                throw new BuildException("Unable to open " + this.destinationFile + " for writing", t);
            }
            Iterator i = this.sourceFiles.iterator();
            while (i.hasNext()) {
                File sourceFile = (File)i.next();
                try {
                    in = new FileInputStream(sourceFile);
                }
                catch (Exception t) {
                    throw new BuildException("Unable to open input file " + sourceFile, t);
                }
                int count = 0;
                do {
                    try {
                        count = in.read(buffer, 0, buffer.length);
                    }
                    catch (Exception t) {
                        throw new BuildException("Unable to read from " + sourceFile, t);
                    }
                    try {
                        if (count <= 0) continue;
                        out.write(buffer, 0, count);
                    }
                    catch (Exception t) {
                        throw new BuildException("Unable to write to " + this.destinationFile, t);
                    }
                } while (count > 0);
                try {
                    in.close();
                }
                catch (Exception t) {
                    throw new BuildException("Unable to close " + sourceFile, t);
                }
                in = null;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    throw new BuildException("Unable to close " + this.destinationFile, ex);
                }
            }
        }
    }

    private void cat() {
        OutputStream os = null;
        Reader reader = null;
        char[] buffer = new char[8192];
        try {
            PrintWriter writer = null;
            if (this.outputWriter != null) {
                writer = new PrintWriter(this.outputWriter);
            } else {
                if (this.destinationFile == null) {
                    os = new LogOutputStream(this, 1);
                } else {
                    File parent = fileUtils.getParentFile(this.destinationFile);
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    os = new FileOutputStream(this.destinationFile.getAbsolutePath(), this.append);
                }
                writer = this.outputEncoding == null ? new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))) : new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, this.outputEncoding)));
            }
            if (this.header != null) {
                if (this.header.getFiltering()) {
                    this.concatenate(buffer, writer, new StringReader(this.header.getValue()));
                } else {
                    writer.print(this.header.getValue());
                }
            }
            reader = this.textBuffer != null ? new StringReader(this.getProject().replaceProperties(this.textBuffer.substring(0))) : new MultiReader();
            this.concatenate(buffer, writer, reader);
            if (this.footer != null) {
                if (this.footer.getFiltering()) {
                    this.concatenate(buffer, writer, new StringReader(this.footer.getValue()));
                } else {
                    writer.print(this.footer.getValue());
                }
            }
            writer.flush();
            if (os != null) {
                os.flush();
            }
        }
        catch (IOException ioex) {
            throw new BuildException("Error while concatenating: " + ioex.getMessage(), ioex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void concatenate(char[] buffer, Writer writer, Reader in) throws IOException {
        int nRead;
        if (this.filterChains != null) {
            ChainReaderHelper helper = new ChainReaderHelper();
            helper.setBufferSize(8192);
            helper.setPrimaryReader(in);
            helper.setFilterChains(this.filterChains);
            helper.setProject(this.getProject());
            in = new BufferedReader(helper.getAssembledReader());
        }
        while ((nRead = in.read(buffer, 0, buffer.length)) != -1) {
            writer.write(buffer, 0, nRead);
        }
        writer.flush();
    }

    private void sanitizeText() {
        if (this.textBuffer != null && this.textBuffer.substring(0).trim().length() == 0) {
            this.textBuffer = null;
        }
    }

    private class MultiReader
    extends Reader {
        private int pos = 0;
        private Reader reader = null;
        private int lastPos = 0;
        private char[] lastChars = new char[Concat.access$300(Concat.this).length()];
        private boolean needAddSeparator = false;

        private MultiReader() {
        }

        private Reader getReader() throws IOException {
            if (this.reader == null) {
                Concat.this.log("Concating file " + Concat.this.sourceFiles.elementAt(this.pos), 3);
                this.reader = Concat.this.encoding == null ? new BufferedReader(new FileReader((File)Concat.this.sourceFiles.elementAt(this.pos))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)Concat.this.sourceFiles.elementAt(this.pos)), Concat.this.encoding));
                for (int i = 0; i < this.lastChars.length; ++i) {
                    this.lastChars[i] = '\u0000';
                }
            }
            return this.reader;
        }

        public int read() throws IOException {
            if (this.needAddSeparator) {
                char ret = Concat.this.eolString.charAt(this.lastPos++);
                if (this.lastPos >= Concat.this.eolString.length()) {
                    this.lastPos = 0;
                    this.needAddSeparator = false;
                }
                return ret;
            }
            while (this.pos < Concat.this.sourceFiles.size()) {
                int ch = this.getReader().read();
                if (ch == -1) {
                    this.reader.close();
                    this.reader = null;
                    if (Concat.this.fixLastLine && this.isMissingEndOfLine()) {
                        this.needAddSeparator = true;
                        this.lastPos = 0;
                    }
                } else {
                    this.addLastChar((char)ch);
                    return ch;
                }
                ++this.pos;
            }
            return -1;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int amountRead = 0;
            while (this.pos < Concat.this.sourceFiles.size() || this.needAddSeparator) {
                if (this.needAddSeparator) {
                    cbuf[off] = Concat.this.eolString.charAt(this.lastPos++);
                    if (this.lastPos >= Concat.this.eolString.length()) {
                        this.lastPos = 0;
                        this.needAddSeparator = false;
                        ++this.pos;
                    }
                    ++off;
                    ++amountRead;
                    if (--len != 0) continue;
                    return amountRead;
                }
                int nRead = this.getReader().read(cbuf, off, len);
                if (nRead == -1 || nRead == 0) {
                    this.reader.close();
                    this.reader = null;
                    if (Concat.this.fixLastLine && this.isMissingEndOfLine()) {
                        this.needAddSeparator = true;
                        this.lastPos = 0;
                        continue;
                    }
                    ++this.pos;
                    continue;
                }
                if (Concat.this.fixLastLine) {
                    for (int i = nRead; i > nRead - this.lastChars.length && i > 0; --i) {
                        this.addLastChar(cbuf[off + i - 1]);
                    }
                }
                off += nRead;
                amountRead += nRead;
                if ((len -= nRead) != 0) continue;
                return amountRead;
            }
            if (amountRead == 0) {
                return -1;
            }
            return amountRead;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        private void addLastChar(char ch) {
            for (int i = this.lastChars.length - 2; i >= 0; --i) {
                this.lastChars[i] = this.lastChars[i + 1];
            }
            this.lastChars[this.lastChars.length - 1] = ch;
        }

        private boolean isMissingEndOfLine() {
            for (int i = 0; i < this.lastChars.length; ++i) {
                if (this.lastChars[i] == Concat.this.eolString.charAt(i)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TextElement
    extends ProjectComponent {
        private String value = "";
        private boolean trimLeading = false;
        private boolean trim = false;
        private boolean filtering = true;
        private String encoding = null;

        public void setFiltering(boolean filtering) {
            this.filtering = filtering;
        }

        private boolean getFiltering() {
            return this.filtering;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setFile(File file) {
            if (!file.exists()) {
                throw new BuildException("File " + file + " does not exist.");
            }
            BufferedReader reader = null;
            try {
                reader = this.encoding == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
                fileUtils;
                this.value = FileUtils.readFully(reader);
            }
            catch (IOException ex) {
                throw new BuildException(ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }

        public void addText(String value) {
            this.value = this.value + this.getProject().replaceProperties(value);
        }

        public void setTrimLeading(boolean strip) {
            this.trimLeading = strip;
        }

        public void setTrim(boolean trim) {
            this.trim = trim;
        }

        public String getValue() {
            if (this.value == null) {
                this.value = "";
            }
            if (this.value.trim().length() == 0) {
                this.value = "";
            }
            if (this.trimLeading) {
                char[] current = this.value.toCharArray();
                StringBuffer b = new StringBuffer(current.length);
                boolean startOfLine = true;
                int pos = 0;
                while (pos < current.length) {
                    char ch = current[pos++];
                    if (startOfLine) {
                        if (ch == ' ' || ch == '\t') continue;
                        startOfLine = false;
                    }
                    b.append(ch);
                    if (ch != '\n' && ch != '\r') continue;
                    startOfLine = true;
                }
                this.value = b.toString();
            }
            if (this.trim) {
                this.value = this.value.trim();
            }
            return this.value;
        }
    }
}

