/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Copy
extends Task {
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector filesets = new Vector();
    private boolean enableMultipleMappings = false;
    protected boolean filtering = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    protected boolean failonerror = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();
    protected Hashtable completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    protected FileUtils fileUtils;
    private Vector filterChains = new Vector();
    private Vector filterSets = new Vector();
    private String inputEncoding = null;
    private String outputEncoding = null;
    private long granularity = 0L;

    public Copy() {
        this.fileUtils = FileUtils.newFileUtils();
        this.granularity = this.fileUtils.getFileTimestampGranularity();
    }

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTofile(File destFile) {
        this.destFile = destFile;
    }

    public void setTodir(File destDir) {
        this.destDir = destDir;
    }

    public FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.filterChains.addElement(filterChain);
        return filterChain;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public void setPreserveLastModified(String preserve) {
        this.setPreserveLastModified(Project.toBoolean(preserve));
    }

    public void setPreserveLastModified(boolean preserve) {
        this.preserveLastModified = preserve;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected Vector getFilterSets() {
        return this.filterSets;
    }

    protected Vector getFilterChains() {
        return this.filterChains;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void setEnableMultipleMappings(boolean enableMultipleMappings) {
        this.enableMultipleMappings = enableMultipleMappings;
    }

    public boolean isEnableMultipleMapping() {
        return this.enableMultipleMappings;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setEncoding(String encoding) {
        this.inputEncoding = encoding;
        if (this.outputEncoding == null) {
            this.outputEncoding = encoding;
        }
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block21: {
            File savedFile = this.file;
            File savedDestFile = this.destFile;
            File savedDestDir = this.destDir;
            FileSet savedFileSet = null;
            if (this.file == null && this.destFile != null && this.filesets.size() == 1) {
                savedFileSet = (FileSet)this.filesets.elementAt(0);
            }
            this.validateAttributes();
            try {
                if (this.file != null) {
                    if (this.file.exists()) {
                        if (this.destFile == null) {
                            this.destFile = new File(this.destDir, this.file.getName());
                        }
                        if (this.forceOverwrite || !this.destFile.exists() || this.file.lastModified() - this.granularity > this.destFile.lastModified()) {
                            this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                        } else {
                            this.log(this.file + " omitted as " + this.destFile + " is up to date.", 3);
                        }
                    } else {
                        String message = "Warning: Could not find file " + this.file.getAbsolutePath() + " to copy.";
                        if (!this.failonerror) {
                            this.log(message);
                        } else {
                            throw new BuildException(message);
                        }
                    }
                }
                for (int i = 0; i < this.filesets.size(); ++i) {
                    boolean isEverythingIncluded;
                    FileSet fs = (FileSet)this.filesets.elementAt(i);
                    DirectoryScanner ds = null;
                    try {
                        ds = fs.getDirectoryScanner(this.getProject());
                    }
                    catch (BuildException e) {
                        if (this.failonerror || !e.getMessage().endsWith(" not found.")) {
                            throw e;
                        }
                        this.log("Warning: " + e.getMessage());
                        continue;
                    }
                    File fromDir = fs.getDir(this.getProject());
                    String[] srcFiles = ds.getIncludedFiles();
                    String[] srcDirs = ds.getIncludedDirectories();
                    boolean bl = isEverythingIncluded = ds.isEverythingIncluded() && !fs.hasSelectors() && !fs.hasPatterns();
                    if (isEverythingIncluded && !this.flatten && this.mapperElement == null) {
                        this.completeDirMap.put(fromDir, this.destDir);
                    }
                    this.scan(fromDir, this.destDir, srcFiles, srcDirs);
                }
                try {
                    this.doFileOperations();
                }
                catch (BuildException e) {
                    if (!this.failonerror) {
                        this.log("Warning: " + e.getMessage(), 0);
                        break block21;
                    }
                    throw e;
                }
            }
            finally {
                this.file = savedFile;
                this.destFile = savedDestFile;
                this.destDir = savedDestDir;
                if (savedFileSet != null) {
                    this.filesets.insertElementAt(savedFileSet, 0);
                }
                this.fileCopyMap.clear();
                this.dirCopyMap.clear();
                this.completeDirMap.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException("Only one of tofile and todir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException("One of tofile or todir must be set.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to copy directories.");
        }
        if (this.destFile != null && this.filesets.size() > 0) {
            if (this.filesets.size() > 1) {
                throw new BuildException("Cannot concatenate multiple files into a single file.");
            }
            FileSet fs = (FileSet)this.filesets.elementAt(0);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            if (srcFiles.length == 0) {
                throw new BuildException("Cannot perform operation from directory to file.");
            }
            if (srcFiles.length != 1) throw new BuildException("Cannot concatenate multiple files into a single file.");
            if (this.file != null) throw new BuildException("Cannot concatenate multiple files into a single file.");
            this.file = new File(ds.getBasedir(), srcFiles[0]);
            this.filesets.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = this.fileUtils.getParentFile(this.destFile);
    }

    protected void scan(File fromDir, File toDir, String[] files, String[] dirs) {
        FileNameMapper mapper = null;
        mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        this.buildMap(fromDir, toDir, files, mapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(fromDir, toDir, dirs, mapper, this.dirCopyMap);
        }
    }

    protected void buildMap(File fromDir, File toDir, String[] names, FileNameMapper mapper, Hashtable map) {
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < names.length; ++i) {
                if (mapper.mapFileName(names[i]) == null) continue;
                v.addElement(names[i]);
            }
            toCopy = new String[v.size()];
            v.copyInto(toCopy);
        } else {
            SourceFileScanner ds = new SourceFileScanner(this);
            toCopy = ds.restrict(names, fromDir, toDir, mapper, this.granularity);
        }
        for (int i = 0; i < toCopy.length; ++i) {
            File src = new File(fromDir, (String)toCopy[i]);
            String[] mappedFiles = mapper.mapFileName((String)toCopy[i]);
            if (!this.enableMultipleMappings) {
                map.put(src.getAbsolutePath(), new String[]{new File(toDir, mappedFiles[0]).getAbsolutePath()});
                continue;
            }
            for (int k = 0; k < mappedFiles.length; ++k) {
                mappedFiles[k] = new File(toDir, mappedFiles[k]).getAbsolutePath();
            }
            map.put(src.getAbsolutePath(), mappedFiles);
        }
    }

    protected void doFileOperations() {
        int i;
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (i = 0; i < toFiles.length; ++i) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-copy of " + fromFile, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                        FilterSetCollection executionFilters = new FilterSetCollection();
                        if (this.filtering) {
                            executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        Enumeration filterEnum = this.filterSets.elements();
                        while (filterEnum.hasMoreElements()) {
                            executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                        }
                        this.fileUtils.copyFile(fromFile, toFile, executionFilters, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.inputEncoding, this.outputEncoding, this.getProject());
                        continue;
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        throw new BuildException(msg, ioe, this.getLocation());
                    }
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int createCount = 0;
            while (e.hasMoreElements()) {
                String[] dirs = (String[])e.nextElement();
                for (i = 0; i < dirs.length; ++i) {
                    File d = new File(dirs[i]);
                    if (d.exists()) continue;
                    if (!d.mkdirs()) {
                        this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                        continue;
                    }
                    ++createCount;
                }
            }
            if (createCount > 0) {
                this.log("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }
}

