## -*- coding: utf-8 -*-
/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
<%!
  def annotated_type(entry):
    if entry.enum:
       type = 'enum'
    else:
       type = entry.type
    if entry.container == 'array':
       type += '[]'

    return type
%>\

/*
 * Autogenerated from camera metadata definitions in
 * /system/media/camera/docs/metadata_definitions.xml
 * *** DO NOT EDIT BY HAND ***
 */

package android.hardware.camera.metadata@${hal_major_version()}.${hal_minor_version()};

% if first_hal_minor_version(hal_major_version()) != hal_minor_version():
  % for i in range(first_hal_minor_version(hal_major_version()),hal_minor_version()):
import android.hardware.camera.metadata@${hal_major_version()}.${i};
  % endfor

% endif
<%    gotSections = False %>\
<%    gotFirstNewSection = False %>\
% for idx, section in enumerate(find_all_sections_added_in_hal(metadata, hal_major_version(), hal_minor_version())):
  % if idx == 0:
<%    gotSections = True %>\
/**
 * Top level hierarchy definitions for camera metadata. *_INFO sections are for
 * the static metadata that can be retrived without opening the camera device.
 */
enum CameraMetadataSection : ${'uint32_t' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else '@%d.%d::CameraMetadataSection' % (hal_major_version(), hal_minor_version()-1)} {
  % endif
  % if first_hal_minor_version(hal_major_version()) != hal_minor_version() and not gotFirstNewSection:
    ${path_name(section) | csym} =
        android.hardware.camera.metadata@${hal_major_version()}.${hal_minor_version()-1}::CameraMetadataSection:ANDROID_SECTION_COUNT,
<% gotFirstNewSection = True %>\
  % else:
    ${path_name(section) | csym},
  % endif

% endfor
% if gotSections:
    ANDROID_SECTION_COUNT${'' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else '_%d_%d' % (hal_major_version(),hal_minor_version())},

    VENDOR_SECTION${'' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else '_%d_%d' % (hal_major_version(),hal_minor_version())} = 0x8000,

};

/**
 * Hierarchy positions in enum space. All vendor extension sections must be
 * defined with tag >= VENDOR_SECTION_START
 */
enum CameraMetadataSectionStart : ${'uint32_t' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else 'android.hardware.camera.metadata@%d.%d::CameraMetadataSectionStart' % (hal_major_version(), hal_minor_version()-1)} {
  % for i in find_all_sections_added_in_hal(metadata, hal_major_version(), hal_minor_version()):
    ${path_name(i) + '.start' | csym} = CameraMetadataSection:${path_name(i) | csym} << 16,

  % endfor
  % if first_hal_minor_version(hal_major_version()) != hal_minor_version() :
    VENDOR_SECTION_START${'_%d_%d' % (hal_major_version(),hal_minor_version())} = CameraMetadataSection:VENDOR_SECTION${'_%d_%d' % (hal_major_version(),hal_minor_version())} << 16,
  % else:
    VENDOR_SECTION_START = CameraMetadataSection:VENDOR_SECTION << 16,
  % endif

};

% else:
// No new metadata sections added in this revision

% endif
/**
 * Main enumeration for defining camera metadata tags added in this revision
 *
 * <p>Partial documentation is included for each tag; for complete documentation, reference
 * '/system/media/camera/docs/docs.html' in the corresponding Android source tree.</p>
 */
enum CameraMetadataTag : ${'uint32_t' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else '@%d.%d::CameraMetadataTag' % (hal_major_version(), hal_minor_version()-1)} {
    % for sec in find_all_sections(metadata):
<%    gotEntries = False %>\
      % for idx,entry in enumerate(filter_added_in_hal_version(remove_synthetic(find_unique_entries(sec)), hal_major_version(), hal_minor_version())):
<%      gotEntries = True %>\
    /** ${entry.name} [${entry.kind}, ${annotated_type(entry)}, ${entry.applied_visibility}]
        % if entry.description:
     *
${entry.description | hidldoc(metadata)}\
        % endif
     */
        % if idx == 0:
          % if find_first_older_used_hal_version(sec, hal_major_version(), hal_minor_version()) == (0, 0):
    ${entry.name + " =" | csym} CameraMetadataSectionStart:${path_name(find_parent_section(entry)) | csym}_START,
          % else:
<%      prevVersion = find_first_older_used_hal_version(sec, hal_major_version(), hal_minor_version()) %>\
    ${entry.name + " =" | csym} ${'android.hardware.camera.metadata@%d.%d' % prevVersion}::CameraMetadataTag:${path_name(find_parent_section(entry)) | csym}${'_END' if prevVersion[1] == first_hal_minor_version(hal_major_version()) else '_END_%d_%d' % prevVersion},
          % endif
        % else:
    ${entry.name + "," | csym}
        % endif

      % endfor
      % if gotEntries:
    ${path_name(sec) | csym}${'_END' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else '_END_%d_%d' % (hal_major_version(),hal_minor_version())},

      % endif
    %endfor
};

/*
 * Enumeration definitions for the various entries that need them
 */
% for sec in find_all_sections(metadata):
  % for entry in filter_has_enum_values_added_in_hal_version(remove_synthetic(find_unique_entries(sec)), hal_major_version(), hal_minor_version()):
    % if entry.enum:

<%    isFirstValue = True %>\
<%    prevValue = None %>\
      % for val in entry.enum.values:
        % if val.hal_major_version == hal_major_version() and val.hal_minor_version == hal_minor_version():
          % if isFirstValue:
              % if prevValue is None:
/** ${entry.name} enumeration values
              % else:
/** ${entry.name} enumeration values added since v${prevValue.hal_major_version}.${prevValue.hal_minor_version}
              % endif
 * @see ${entry.name | csym}
 */
enum CameraMetadataEnum${entry.name | pascal_case} :${' uint32_t' if prevValue is None else '\n        @%d.%d::CameraMetadataEnum%s' % (prevValue.hal_major_version, prevValue.hal_minor_version, pascal_case(entry.name))} {
          % endif
          % if val.id is None:
    ${entry.name | csym}_${val.name},
          % else:
    ${'%s_%s'%(csym(entry.name), val.name) | pad(65)} = ${val.id},
          % endif
<%        isFirstValue = False %>\
        % else:
<%        prevValue = val %>\
        % endif
      % endfor
};
    % endif
  % endfor
% endfor
