## -*- coding: utf-8 -*-
/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated from camera metadata definitions in
 * /system/media/camera/docs/metadata_definitions.xml
 * *** DO NOT EDIT BY HAND ***
 */

<%!
  def annotated_type(entry):
    if entry.enum:
       type = 'enum'
    else:
       type = entry.type
    if entry.container == 'array':
       type += '[]'

    return type
%>\

package android.hardware.camera.metadata@${hal_major_version()}.${hal_minor_version()};

% if first_hal_minor_version(hal_major_version()) != hal_minor_version():
/* Include definitions from all prior minor HAL metadata revisions */
  % for i in range(first_hal_minor_version(hal_major_version()),hal_minor_version()):
import android.hardware.camera.metadata@${hal_major_version()}.${i};
  % endfor

% endif
/**
 * Top level hierarchy definitions for camera metadata. *_INFO sections are for
 * the static metadata that can be retrived without opening the camera device.
 */
enum CameraMetadataSection : ${'uint32_t' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else 'android.hardware.camera.metadata@%d.%d::CameraMetadataSection' % (hal_major_version(), hal_minor_version()-1)} {
% for idx, section in enumerate(find_all_sections_added_in_hal(metadata, hal_major_version(), hal_minor_version())):
  % if idx == 0 and first_hal_minor_version(hal_major_version()) != hal_minor_version():
    ${path_name(section) | csym} =
        android.hardware.camera.metadata@${hal_major_version()}.${hal_minor_version()-1}::CameraMetadataSection::ANDROID_SECTION_COUNT,
  % else:
    ${path_name(section) | csym},
  % endif

% endfor
    ANDROID_SECTION_COUNT,

    VENDOR_SECTION = 0x8000,

};

/**
 * Hierarchy positions in enum space. All vendor extension sections must be
 * defined with tag >= VENDOR_SECTION_START
 */
enum CameraMetadataSectionStart : ${'uint32_t' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else 'android.hardware.camera.metadata@%d.%d::CameraMetadataSectionStart' % (hal_major_version(), hal_minor_version()-1)} {
  % for i in find_all_sections_added_in_hal(metadata, hal_major_version(), hal_minor_version()):
    ${path_name(i) + '.start' | csym} = CameraMetadataSection:${path_name(i) | csym} << 16,

  % endfor
    VENDOR_SECTION_START = CameraMetadataSection:VENDOR_SECTION << 16,

};

/**
 * Main enum for defining camera metadata tags. New entries must always go
 * before the section _END tag to preserve existing enumeration values.
 */
enum CameraMetadataTag : ${'uint32_t' if first_hal_minor_version(hal_major_version()) == hal_minor_version() else 'android.hardware.camera.metadata@%d.%d::CameraMetadataTag' % (hal_major_version(), hal_minor_version()-1)} {
    % for sec in find_all_sections(metadata):
<%    gotEntries = False %>\
      % for idx,entry in enumerate(filter_added_in_hal_version(remove_synthetic(find_unique_entries(sec)), hal_major_version(), hal_minor_version())):
<%      gotEntries = True %>\
        % if idx == 0:
    ${entry.name + " = " | csym,ljust(50)}// ${annotated_type(entry) | ljust(12) } | ${entry.applied_visibility}
          % if find_first_older_used_hal_version(sec, hal_major_version(), hal_minor_version()) == (0, 0):
            CameraMetadataSectionStart:${path_name(find_parent_section(entry)) | csym}_START,
          % else:
            ${'android.hardware.camera.metadata@%d.%d' % find_first_older_used_hal_version(sec, hal_major_version(), hal_minor_version())}::CameraMetadataTag:${path_name(find_parent_section(entry)) | csym}_END,
          % endif
        % else:
    ${entry.name + "," | csym,ljust(50)}// ${annotated_type(entry) | ljust(12)} | ${entry.applied_visibility}
        % endif
      % endfor
      % if gotEntries:
    ${path_name(sec) | csym}_END,

      % endif
    %endfor
};

/**
 * Enumeration definitions for the various entries that need them
 */
% for sec in find_all_sections(metadata):
  % for entry in filter_added_in_hal_version(remove_synthetic(find_unique_entries(sec)), hal_major_version(), hal_minor_version()):
    % if entry.enum:
// ${entry.name}
enum CameraMetadataEnum${entry.name | pascal_case} : uint32_t {
      % for val in entry.enum.values:
        % if val.id is None:
    ${entry.name | csym}_${val.name},
        % else:
    ${'%s_%s'%(csym(entry.name), val.name) | pad(65)} = ${val.id},
        % endif
      % endfor
};

    % endif
  % endfor
% endfor
