/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class AwkLiteralInteger extends AwkExpression {

	/**
	 * 
	 */
	public static final AwkLiteralInteger TRUE =
		new AwkLiteralInteger(BigInteger.ONE);

	/**
	 * 
	 */
	public static final AwkLiteralInteger FALSE =
		new AwkLiteralInteger(BigInteger.ZERO);

	private BigInteger value;

	public AwkLiteralInteger(BigInteger value) {
		this.value = value;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		return AwkInteger.valueOf(value);
	}

}
