/*
 * Copyright 2009-2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unix.glob;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import net.morilib.unix.charset.IntInterval;
import net.morilib.unix.charset.IntRange;
import net.morilib.unix.charset.UnixCharSetException;
import net.morilib.unix.charset.UnixCharSets;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/04/24
 */
public class Wildcard {

	//
	private IntRange[] chars;
	private List<Boolean> repeat;

	//
	private Wildcard(IntRange[] chars, List<Boolean> repeat) {
		this.chars   = chars;
		this.repeat  = repeat;
	}

	/**
	 * 
	 * @param cs
	 * @return
	 */
	public boolean matches(CharSequence cs) {
		Set<Integer> ss = new HashSet<Integer>();
		Set<Integer> ad = new HashSet<Integer>();

		ss.add(0);
		for(int p = 0; p < cs.length(); p++) {
			Iterator<Integer> i = ss.iterator();
			int c = cs.charAt(p);

			while(i.hasNext()) {
				int s = i.next();

				if(chars[s].contains(c)) {
					ad.add(s + 1);
				}
				if(!repeat.get(s)) {
					i.remove();
				}
			}
			ss.addAll(ad);
			ad.clear();
			if(ss.isEmpty())  break;
		}
		return (ss.contains(chars.length - 1));
	}

	/**
	 * 
	 * @param pt
	 * @return
	 * @throws WildcardSyntaxException 
	 */
	public static Wildcard compile(CharSequence pt) {
		List<IntRange> rl = new ArrayList<IntRange>();
		List<Boolean>  rp = new ArrayList<Boolean>();
		boolean b = true;
		int c, p = 0;

		for(; p < pt.length(); p++) {
			switch(c = pt.charAt(p)) {
			case '*':
				if(b) {
					rp.add(true);
				}
				b = false;
				break;
			case '?':
				rl.add(UnixCharSets.ALL_CHAR);
				if(b) {
					rp.add(false);
				}
				b = true;
				break;
			case '[':
				int z = p + 1;

				for(; true; z++) {
					if(z >= pt.length()) {
						throw new WildcardSyntaxException();
					} else if(pt.charAt(z) == ']') {
						break;
					}
				}

				try {
					rl.add(UnixCharSets.parse(
							pt.subSequence(p + 1, z)));
				} catch(UnixCharSetException e) {
					throw new WildcardSyntaxException(e);
				}
				if(b) {
					rp.add(false);
				}
				b = true;
				p = z;
				break;
			default:
				rl.add(new IntInterval((char)c));
				if(b) {
					rp.add(false);
				}
				b = true;
				break;
			}
		}

		if(b) {
			rp.add(false);
		}
		rl.add(IntRange.O);
		return new Wildcard(rl.toArray(new IntRange[0]), rp);
	}

	/**
	 * 
	 * @param pt
	 * @param cs
	 * @return
	 */
	public static boolean matches(CharSequence pt, CharSequence cs) {
		return compile(pt).matches(cs);
	}

}
