/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.expr;

/**
 * Cプリプロセッサで扱う値のインターフェースです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public interface CpreValue extends Comparable<CpreValue> {

	/**
	 * 真の値です。
	 */
	public static final CpreValue TRUE = new CpreLiteralInteger(1);

	/**
	 * 偽の値です。
	 */
	public static final CpreValue FALSE = new CpreLiteralInteger(0);

	/**
	 * 浮動小数点に変換します。
	 * 
	 * @return 浮動小数点
	 */
	public double toFloat();

	/**
	 * 整数に変換します。
	 * 
	 * @return 整数
	 */
	public long toLong();

	/**
	 * 論理値に変換します。
	 * 
	 * @return 論理値
	 */
	public boolean toBoolean();

	/**
	 * 浮動小数点のときtrueを得ます。
	 * 
	 * @return 浮動小数点のときtrue
	 */
	public boolean isFloat();

	/**
	 * 整数のときtrueを得ます。
	 * 
	 * @return 整数のときtrue
	 */
	public boolean isLong();

}
