/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import java.nio.charset.Charset;

import javax.swing.JComboBox;

/**
 * 文字セットを要素に持つコンボボックスです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class CharsetComboBox extends JComboBox {

	/**
	 * コンボボックスを生成します。
	 */
	public CharsetComboBox() {
		Charset utf8 = Charset.forName("UTF-8");

		addItem("(system default)");
		addItem(utf8);
		for(Charset s : Charset.availableCharsets().values()) {
			if(!s.equals(utf8) &&
					!s.toString().startsWith("x") &&
					!s.toString().startsWith("X")) {
				addItem(s);
			}
		}
	}

	/**
	 * 選択された文字セットを得ます。
	 */
	public Charset getSelectedCharset() {
		Object o = getSelectedItem();

		return (o instanceof Charset) ? (Charset)o : null;
	}

}
