/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.misc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;

/**
 * 行番号を持ち、1文字読み戻し可能なストリームです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class PushbackLineNumberReader extends Reader
implements PushbackLineNumberReadable {

	//
	private LineNumberReader lrd;
	private PushbackReader pbrd;

	/**
	 * インスタンスを生成します。
	 * 
	 * @param rd ラップされるReader
	 */
	public PushbackLineNumberReader(Reader rd) {
		lrd  = new LineNumberReader(rd);
		pbrd = new PushbackReader(lrd);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.misc.PushbackLineNumberReadable#unread(int)
	 */
	public void unread(int c) throws IOException {
		pbrd.unread(c);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.misc.PushbackLineNumberReadable#getLineNumber()
	 */
	public int getLineNumber() {
		return lrd.getLineNumber();
	}

	/* (non-Javadoc)
	 * @see java.io.Reader#close()
	 */
	@Override
	public void close() throws IOException {
		pbrd.close();
	}

	/* (non-Javadoc)
	 * @see java.io.Reader#read(char[], int, int)
	 */
	@Override
	public int read(char[] cbuf, int off, int len) throws IOException {
		return pbrd.read();
	}

	/* (non-Javadoc)
	 * @see java.io.Reader#read(char[])
	 */
	@Override
	public int read(char[] cbuf) throws IOException {
		return pbrd.read(cbuf);
	}

	/* (non-Javadoc)
	 * @see java.io.Reader#read(java.nio.CharBuffer)
	 */
	@Override
	public int read(CharBuffer target) throws IOException {
		return pbrd.read(target);
	}

	/* (non-Javadoc)
	 * @see java.io.Reader#read()
	 */
	@Override
	public int read() throws IOException {
		return pbrd.read();
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.misc.PushbackLineNumberReadable#resetPrompt()
	 */
	public void resetPrompt() {
		// do nothing
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.misc.PushbackLineNumberReadable#isNewline()
	 */
	public boolean isNewline() {
		return false;
	}

}
