/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;

/**
 * wコマンドを処理するクラスです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class SedWCommand implements SedCommand {

	private String filename;

	/**
	 * コマンドを生成します。
	 * 
	 * @param filename ファイル名
	 */
	public SedWCommand(String filename) {
		this.filename = filename;
	}

	public String getLongDescription() {
		return "Write the pattern space to the file";
	}

	public char getName() {
		return 'w';
	}

	public void process(SedSpace s,
			SedLineBuffer rd) throws IOException {
		s.setFileToWrite(filename);
	}

	/**
	 * ファイル名を得ます。
	 * 
	 * @return ファイル名
	 */
	public String getFilename() {
		return filename;
	}

	public int hashCode() {
		return filename.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof SedWCommand) {
			return filename.equals(((SedWCommand)o).filename);
		}
		return false;
	}

	public String toString() {
		return "w" + filename;
	}

}
