/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.builtin.ShBuiltInCommands;
import net.morilib.sh.misc.XtraceStream;

public class ShRuntime {

	private static ShRuntime INSTANCE = new ShRuntime();

	/**
	 * 
	 * @return
	 */
	public static ShRuntime getInstance() {
		return INSTANCE;
	}

	/**
	 * 
	 * @param env
	 * @param script
	 * @return
	 */
	public int eval(ShEnvironment env,
			ShFileSystem fs,
			InputStream stdin,
			PrintStream stdout,
			PrintStream stderr,
			XtraceStream prompt,
			String script) throws IOException, ShSyntaxException {
		ShTree p;

		try {
			p = ShParser.parse(script);
			p = ShTrees.compile(p);
			return p.eval(env, fs, ShBuiltInCommands.getInstance(),
					this, stdin, stdout, stderr, prompt);
		} finally {
			stdout.flush();
			stderr.flush();
		}
	}

}
