/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import net.morilib.sh.ShCommandExecuteTest;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/06/15
 */
public class ShTrTest extends ShCommandExecuteTest {

	public void test001() {
		piw.println("abcde");
		piw.close();
		exe("tr abc ABC", 0);
		eot("ABCde");
		eot();
	}

	public void test002() {
		piw.println("abcde!");
		piw.close();
		exe("tr a-z A-Z", 0);
		eot("ABCDE!");
		eot();
	}

	public void test003() {
		piw.println("abcde!");
		piw.close();
		exe("tr a-z A-Z", 0);
		eot("ABCDE!");
		eot();
	}

	public void test004() {
		piw.println("abcde");
		piw.close();
		exe("tr -d abc", 0);
		eot("de");
		eot();
	}

	public void test005() {
		piw.print("abcde");
		piw.close();
		exe("tr -d a-z", 0);
		eot();
	}

	public void test006() {
		piw.println("aaabbbbccccde");
		piw.close();
		exe("tr -s bcd", 0);
		eot("aaabcde");
		eot();
	}

	public void test007() {
		piw.println("aaabbbbccccde");
		piw.close();
		exe("tr -s a-z", 0);
		eot("abcde");
		eot();
	}

	public void test008() {
		piw.println("\u0007\u0007\u0008\u0008\u000b\u000b\u0009\u0009\u000b\u000b\n\n");
		piw.println("\\\\\\      !!!!");
		piw.close();
		exe("tr -s '\\a\\b\\f\\n\\t\\v\\\\\\u0020\\041'", 0);
		eot("\u0007\u0008\u000b\u0009\u000b");
		eot("\\ !");
		eot();
	}

	public void test009() {
		piw.println("!$a");
		piw.close();
		exe("tr -c ' ' '0123456789\\nbcdef0123456789abcdef0123456789'", 0);
		eot("039");
	}

	public void test010() {
		piw.println("aaabbbbccccde");
		piw.close();
		exe("tr -sd a bcd", 0);
		eot("bcde");
		eot();
	}

	public void test011() {
		piw.println("abcde!");
		piw.close();
		exe("tr '[:lower:]' '[:upper:]'", 0);
		eot("ABCDE!");
		eot();
	}

	public void test012() {
		piw.println("ABCDE!");
		piw.close();
		exe("tr '[:upper:]' '[:lower:]'", 0);
		eot("abcde!");
		eot();
	}

	public void test013() {
		piw.println("abcde01234!");
		piw.close();
		exe("tr -d '[:alnum:]'", 0);
		eot("!");
		eot();
	}

	public void test014() {
		piw.println("abcde01234!");
		piw.close();
		exc("tr -cd '[:alnum:]'", 0);
		eot("abcde01234");
		eot();
	}

	public void test015() {
		piw.println("abcde01234!");
		piw.close();
		exe("tr -d '[:alpha:]'", 0);
		eot("01234!");
		eot();
	}

	public void test016() {
		piw.println("abcde01234!");
		piw.close();
		exc("tr -cd '[:alpha:]'", 0);
		eot("abcde");
		eot();
	}

	public void test017() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exe("tr -d '[:blank:]'", 0);
		eot("abcde01234!");
		eot();
	}

	public void test018() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -cd '[:blank:]'", 0);
		eot("  \t\t");
		eot();
	}

	public void test019() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -d '[:cntrl:]'", 0);
		eot("abcde  01234!");
		eot();
	}

	public void test020() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exe("tr -cd '[:cntrl:]'", 0);
		eot("\t\t");
		eot();
	}

	public void test021() {
		piw.println("abcde01234!");
		piw.close();
		exc("tr -d '[:digit:]'", 0);
		eot("abcde!");
		eot();
	}

	public void test022() {
		piw.println("abcde01234!");
		piw.close();
		exc("tr -cd '[:digit:]'", 0);
		eot("01234");
		eot();
	}

	public void test023() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -d '[:graph:]'", 0);
		eot("  \t\t");
		eot();
	}

	public void test024() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -cd '[:graph:]'", 0);
		eot("abcde01234!");
		eot();
	}

	public void test025() {
		piw.println("abcdeABCDE01234!");
		piw.close();
		exc("tr -d '[:lower:]'", 0);
		eot("ABCDE01234!");
		eot();
	}

	public void test026() {
		piw.println("abcdeABCDE01234!");
		piw.close();
		exc("tr -cd '[:lower:]'", 0);
		eot("abcde");
		eot();
	}

	public void test027() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -d '[:print:]'", 0);
		eot("\t\t");
		eot();
	}

	public void test028() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -cd '[:print:]'", 0);
		eot("abcde  01234!");
		eot();
	}

	public void test029() {
		piw.println("!\"#$%&'()=-~^|\\[]{}*+_?.><,@`;:");
		piw.close();
		exc("tr -d '[:punct:]'", 0);
		eot("");
		eot();
	}

	public void test030() {
		piw.println("！”＃＄％＆’（）＝ー＾〜￥＠｀｜｛｝［］：＊；＋＿？／．，．");
		piw.close();
		exc("tr -d '[:punct:]'", 0);
		eot("");
		eot();
	}

	public void test031() {
		piw.println("「俺の妹がこんなに可愛いわけがない。」");
		piw.close();
		exc("tr -d '[:punct:]'", 0);
		eot("俺の妹がこんなに可愛いわけがない");
		eot();
	}

	public void test032() {
		piw.println("水樹奈々");
		piw.close();
		exc("tr -d '[:punct:]'", 0);
		eot("水樹奈々");
		eot();
	}

	public void test033() {
		piw.println("「俺の妹がこんなに可愛いわけがない。」");
		piw.close();
		exc("tr -cd '[:punct:]'", 0);
		eot("「。」");
		eot();
	}

	public void test034() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -d '[:space:]'", 0);
		eot("abcde01234!");
		eot();
	}

	public void test035() {
		piw.println("abcde  01234\t\t!");
		piw.close();
		exc("tr -cd '[:space:]'", 0);
		eot("  \t\t");
		eot();
	}

	public void test036() {
		piw.println("abcdeABCDE01234!");
		piw.close();
		exc("tr -d '[:upper:]'", 0);
		eot("abcde01234!");
		eot();
	}

	public void test037() {
		piw.println("abcdeABCDE01234!");
		piw.close();
		exc("tr -cd '[:upper:]'", 0);
		eot("ABCDE");
		eot();
	}

	public void test038() {
		piw.println("abcdefgABCDEFG01234567890!");
		piw.close();
		exc("tr -d '[:xdigit:]'", 0);
		eot("gG!");
		eot();
	}

	public void test039() {
		piw.println("abcdefgABCDEFG01234567890!");
		piw.close();
		exc("tr -cd '[:xdigit:]'", 0);
		eot("abcdefABCDEF01234567890");
		eot();
	}

}
