/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import java.util.ArrayList;
import java.util.List;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.printf.Printf;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

/**
 * 組み込み関数sprintfの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkSprintf extends AwkFunction {

	/**
	 * 
	 */
	public AwkSprintf() {
		super("sprintf", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		List<AwkValue> l = new ArrayList<AwkValue>();
		String f, g;

		f = args.size() < 1 ? "" : args.get(0).toString(ns);
		for(int i = 1; i < args.size(); i++)  l.add(args.get(i));
		g = Printf.getInstance().format(
				f, l.toArray(new Object[0]));
		return AwkString.valueOf(g);
	}

}
