/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import net.morilib.awk.AwkSQLException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkPreparedStatementUpdateFunction extends AwkFunction
implements AwkSQLCloseable {

	private PreparedStatement stat;

	/**
	 * 
	 * @param stat
	 */
	public AwkPreparedStatementUpdateFunction(PreparedStatement stat) {
		super("qus", null);
		this.stat = stat;
	}

	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		try {
			for(int i = 0; i < args.size(); i++) {
				stat.setString(i + 1, args.get(i).toString());
			}
			return AwkInteger.valueOf(stat.executeUpdate());
		} catch(SQLException e) {
			throw new AwkSQLException(e);
		}
	}

	public void closeSQL() throws SQLException {
		stat.close();
	}

}
