/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.line;

import net.morilib.sed.SedLineMatcher;
import net.morilib.sed.SedPatternEngine;

/**
 * 行番号にマッチするマッチ器です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class SedNumberLineMatcher implements SedLineMatcher {

	//
	private long lineno;

	/**
	 * マッチ器を生成します。
	 * 
	 * @param lineno 行番号
	 */
	public SedNumberLineMatcher(long lineno) {
		this.lineno = lineno;
	}

	/**
	 * 行番号を得ます。
	 * 
	 * @return 行番号
	 */
	public long getLineno() {
		return lineno;
	}

	public boolean matches(SedPatternEngine pa, String s, long lineno,
			long relno, boolean lastno) {
		return this.lineno == lineno;
	}

	public int hashCode() {
		return (int)lineno;
	}

	public boolean equals(Object o) {
		if(o instanceof SedNumberLineMatcher) {
			return lineno == ((SedNumberLineMatcher)o).lineno;
		}
		return false;
	}

	public String toString() {
		return Long.toString(lineno);
	}

}
