package net.morilib.sh;

public class ShCommandBuildInExecuteTest extends ShCommandExecuteTest {

	public void testEcho001() {
		exe("echo -e '\\a\\b\\e\\E\\f\\t\\v'", 0);
		eot("\u0007\u0008\u001b\u001b\u000c\t\u000b");
	}

	public void testEcho002() {
		exe("echo -e 'a\\rb\\n'", 0);
		eot("a");
		eot("b");
	}

	public void testEcho003() {
		exe("echo '\\a\\b\\e\\E\\f\\t\\v\\n\\r'", 0);
		eot("\\a\\b\\e\\E\\f\\t\\v\\n\\r");
	}

	public void testEcho004() {
		exe("echo -E '\\a\\b\\e\\E\\f\\t\\v\\n\\r'", 0);
		eot("\\a\\b\\e\\E\\f\\t\\v\\n\\r");
	}

	public void testEcho005() {
		exe("echo -n aaaa", 0);
		exe("echo bbbb", 0);
		eot("aaaabbbb");
	}

	public void testEcho006() {
		exe("echo -e '\\caaaa'", 0);
		exe("echo bbbb", 0);
		eot("aaaabbbb");
	}

	public void testEcho007() {
		exe("echo '\\caaaa'", 0);
		exe("echo bbbb", 0);
		eot("\\caaaa");
		eot("bbbb");
	}

	public void testEcho008() {
		exe("echo -e '\\x20\\xb'", 0);
		eot(" \u000b");
	}

	public void testEcho009() {
		exe("echo -e '\\u0020\\u020\\u20\\ub'", 0);
		eot("   \u000b");
	}

	public void testEcho010() {
		exe("echo -e '\\0040\\040\\04\\377\\40\\x1'", 0);
		eot("  \u0004\u00ff \u0001");
	}

	public void testRead001() {
		piw.println("aaaa bbbb");  piw.flush();
		exe("read a b", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
	}

	public void testRead002() {
		piw.println("aaaa bbbb cccc");  piw.flush();
		exe("read a b", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb cccc");
	}

	public void testRead003() {
		piw.println("aaaa bbbb  cccc");  piw.flush();
		exe("read a b", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb cccc");
	}

	public void testRead004() {
		piw.println("aaaa bbbb cccc dddd");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "dddd");
	}

	public void testRead005() {
		piw.println("aaaa bbbb cccc");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "");
	}

	public void testRead006() {
		piw.println("aaaa");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "");
		assertEquals(env.find("c"), "");
		assertEquals(env.find("d"), "");
	}

	public void testRead007() {
		piw.println("");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "");
		assertEquals(env.find("b"), "");
		assertEquals(env.find("c"), "");
		assertEquals(env.find("d"), "");
	}

	public void testRead008() {
		piw.println("aaaa bbbb  cccc");  piw.flush();
		exe("read a", 0);
		assertEquals(env.find("a"), "aaaa bbbb cccc");
	}

	public void testRead009() {
		piw.println("aaaa bbbb cccc dddd ");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "dddd");
	}

	public void testRead010() {
		piw.println("  aaaa bbbb cccc dddd ");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "dddd");
	}

	public void testRead011() {
		piw.println("aaaa bbbb \\cccc dddd");  piw.flush();
		exe("read -r a", 0);
		assertEquals(env.find("a"), "aaaa bbbb \\cccc dddd");
	}

	public void testRead012() {
		piw.println("aaaa bbbb \\cccc dddd");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "dddd");
	}

	public void testRead013() {
		piw.println("aaaa bbbb \\\ncccc dddd");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "dddd");
	}

	public void testRead014() {
		piw.println("aaaa bbbb \\\r\ncccc dddd");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "dddd");
	}

	public void testRead015() {
		piw.println("aaaa bbbb \\\rcccc dddd");  piw.flush();
		exe("read a b c d", 0);
		assertEquals(env.find("a"), "aaaa");
		assertEquals(env.find("b"), "bbbb");
		assertEquals(env.find("c"), "cccc");
		assertEquals(env.find("d"), "dddd");
	}

	public void testExit001() {
		exe("exit 0; false", 0);
	}

	public void testCd001() {
		env.bind("HOME", "haruka");
		env.bind("PWD", "ritsuko");
		exe("cd azusa", 0);
		assertEquals("/azusa", env.find("PWD"));
		assertEquals("ritsuko", env.find("OLDPWD"));
		exe("pwd", 0);
		eot("/azusa");
	}

	public void testCd002() {
		env.bind("HOME", "haruka");
		env.bind("PWD", "ritsuko");
		exe("cd", 0);
		assertEquals("/haruka", env.find("PWD"));
		assertEquals("ritsuko", env.find("OLDPWD"));
	}

	public void testCd003() {
		env.bind("HOME", "haruka");
		env.bind("PWD", "ritsuko");
		exe("cd notdirectory", 1);
	}

	public void testExport001() {
		exe("aaa=1", 0);
		exe("export aaa", 0);
		assertEquals(rev.find("aaa"), "1");
		exe("aaa=2", 0);
		assertEquals(rev.find("aaa"), "2");
	}

	public void testExport002() {
		exe("export aaa=1", 0);
		assertEquals(rev.find("aaa"), "1");
		exe("aaa=2", 0);
		assertEquals(rev.find("aaa"), "2");
	}

	public void testExport003() {
		exe("export aaa=", 0);
		assertEquals(rev.find("aaa"), "");
		exe("aaa=2", 0);
		assertEquals(rev.find("aaa"), "2");
	}

	public void testExport004() {
		exe("export aaa", 0);
		assertEquals(rev.find("aaa"), "");
		exe("aaa=2", 0);
		assertEquals(rev.find("aaa"), "2");
	}

	public void testExport005() {
		exe("export aaa=1 bbb=2", 0);
		assertEquals(rev.find("aaa"), "1");
		assertEquals(rev.find("bbb"), "2");
	}

	public void testSource001() {
		exe(". test.sh", 0);
		exe("echo $aaa", 0);
		eot("aaa");
		eot("1");
	}

	public void testSource002() {
		exe("source test.sh", 0);
		exe("echo $aaa", 0);
		eot("aaa");
		eot("1");
	}

	public void testSet001() {
		exe("echo *", 0);
		exe("set -f", 0);
		exe("echo *", 0);
		exe("set +f", 0);
		exe("echo *", 0);
		eot("haruka chihaya yukiho azusa ritsuko");
		eot("*");
		eot("haruka chihaya yukiho azusa ritsuko");
	}

	public void testSet002() {
		exe("echo *", 0);
		exe("set -o noglob", 0);
		exe("echo *", 0);
		exe("set +f", 0);
		exe("echo *", 0);
		eot("haruka chihaya yukiho azusa ritsuko");
		eot("*");
		eot("haruka chihaya yukiho azusa ritsuko");
	}

	public void testSet003() {
		exe("set -C", 0);
		err("echo bbb > 1.txt", 0);
		exe("set +C", 0);
		exe("echo aaa > 1.txt", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "aaa");
	}

	public void testSet004() {
		exe("set -o noclobber", 0);
		err("echo bbb > 1.txt", 0);
		exe("set +o noclobber", 0);
		exe("echo aaa > 1.txt", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "aaa");
	}

	public void testEval001() {
		exe("eval echo aaa", 0);
		eot("aaa");
	}

	public void testEval002() {
		exe("aaa='$bbb'", 0);
		exe("bbb=1", 0);
		exe("eval echo $aaa", 0);
		eot("1");
	}

	public void testEval003() {
		exe("aaa='echo aaa && echo bbb'", 0);
		exe("eval $aaa", 0);
		eot("aaa");
		eot("bbb");
	}

	public void testEval004() {
		exe("eval", 0);
		eot();
	}

	public void testReadonly001() {
		exe("1=aa", 0);
		exe("72=aa", 0);
		eet("1: readonly variable");
		eet("72: readonly variable");
	}

	public void testReadonly002() {
		exe("aaa=zzz bbb=zzz", 0);
		exe("readonly aaa bbb", 0);
		exe("aaa=aa", 0);
		exe("bbb=aa", 0);
		eet("aaa: readonly variable");
		eet("bbb: readonly variable");
	}

	public void testReadonly003() {
		exe("aaa=zzz bbb=zzz ccc=zzz", 0);
		exe("readonly aaa bbb", 0);
		exe(    "function aaa {\n" +
				"  local bbb\n" +
				"  aaa=aa\n" +
				"  bbb=bb\n" +
				"  ccc=cc" +
				"  readonly ccc\n" +
				"}", 0);
		exe("aaa", 0);
		eet("aaa: readonly variable");
		eet();
	}

	public void testReadonly004() {
		exe("export aaa=zzz bbb=zzz ccc=zzz", 0);
		exe("readonly aaa bbb", 0);
		exe(    "function aaa {\n" +
				"  local bbb\n" +
				"  aaa=aa\n" +
				"  bbb=bb\n" +
				"  ccc=cc" +
				"  readonly ccc\n" +
				"}", 0);
		exe("aaa", 0);
		eet("aaa: readonly variable");
		eet();
	}

	public void testReadonly005() {
		exe("export aaa=zzz bbb=zzz ccc=zzz", 0);
		exe("readonly aaa bbb", 0);
		exe("export aaa=zzz", 0);
		eet("aaa: readonly variable");
		eet();
	}

	public void testUnset001() {
		exe("aaa=zzz", 0);
		exe("echo $aaa", 0);
		exe("unset aaa", 0);
		exe("echo $aaa", 0);
		eot("zzz");
		eot("");
	}

	public void testUnset002() {
		exe("aaa=zzz bbb=zzz", 0);
		exe("readonly aaa bbb", 0);
		exe("unset aaa", 0);
		exe("echo $aaa", 0);
		eet("aaa: readonly variable");
		eot("zzz");
	}

	public void testUnset003() {
		exe("aaa=zzz bbb=zzz ccc=zzz", 0);
		exe("readonly ccc", 0);
		exe(    "function aaa {\n" +
				"  local bbb\n" +
				"  bbb=ccc\n" +
				"  unset aaa bbb ccc\n" +
				"}", 0);
		exe("aaa", 0);
		exe("echo $aaa $bbb $ccc", 0);
		eet("ccc: readonly variable");
		eot("zzz zzz");
	}

	public void testShift001() {
		env.put("1", "11");
		env.put("2", "22");
		env.put("3", "33");
		env.put("#", "4");
		exe("echo $* $#", 0);
		exe("shift", 0);
		exe("echo $* $#", 0);
		eot("11 22 33 4");
		eot("22 33 3");
	}

	public void testShift002() {
		env.put("1", "11");
		env.put("2", "22");
		env.put("3", "33");
		env.put("#", "4");
		exe("echo $* $#", 0);
		exe("shift 2", 0);
		exe("echo $* $#", 0);
		eot("11 22 33 4");
		eot("33 2");
	}

	public void testShift003() {
		env.put("1", "11");
		env.put("2", "22");
		env.put("3", "33");
		env.put("#", "4");
		exe("echo $* $#", 0);
		exe("shift 3", 0);
		exe("echo $* $#", 0);
		eot("11 22 33 4");
		eot("1");
	}

	public void testShift004() {
		env.put("1", "11");
		env.put("2", "22");
		env.put("3", "33");
		env.put("#", "4");
		exe("echo $* $#", 0);
		exe("shift 4", 0);
		exe("echo $* $#", 0);
		eot("11 22 33 4");
		eot("1");
	}

	public void testBasename001() {
		exe("basename /aaa/bbb/ccc.sh", 0);
		eot("ccc.sh");
	}

	public void testBasename002() {
		exe("basename ccc.sh", 0);
		eot("ccc.sh");
	}

	public void testBasename003() {
		exe("basename /aaa/bbb/ccc.sh .sh", 0);
		eot("ccc");
	}

	public void testBasename004() {
		exe("basename /aaa/bbb/ccc", 0);
		eot("ccc");
	}

	public void testBasename005() {
		exe("basename /aaa/bbb/ccc/", 0);
		eot("ccc");
	}

	public void testBasename006() {
		exe("basename /ccc.sh", 0);
		eot("ccc.sh");
	}

	public void testBasename007() {
		exe("basename /ccc.sh/", 0);
		eot("ccc.sh");
	}

	public void testDirname001() {
		exe("dirname /aaa/bbb/ccc.sh", 0);
		eot("/aaa/bbb");
	}

	public void testDirname002() {
		exe("dirname ccc.sh", 0);
		eot(".");
	}

	public void testDirname003() {
		exe("dirname ccc.sh/", 0);
		eot(".");
	}

	public void testDirname004() {
		exe("dirname /aaa/bbb/ccc", 0);
		eot("/aaa/bbb");
	}

	public void testDirname005() {
		exe("dirname /aaa/bbb/ccc/", 0);
		eot("/aaa/bbb");
	}

	public void testDirname006() {
		exe("dirname /aaa", 0);
		eot("/");
	}

	public void testDirname007() {
		exe("dirname /aaa/", 0);
		eot("/");
	}

}
