package net.morilib.sh;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import junit.framework.TestCase;

public class ShFileGlobberTest extends TestCase {

	static void eqs(String p, String... args) {
		Set<String> a = new HashSet<String>(Arrays.asList(args));
		Set<String> b = new HashSet<String>();
		Collection<ShFile> f;

		f = ShFiles.glob(p, new ShFileSystemStub());
		for(ShFile x : f) {
			b.add(x.toString());
		}
		assertEquals(a, b);
	}

	static void eqt(String p, String... args) {
		Set<String> a = new HashSet<String>(Arrays.asList(args));
		Set<String> b = new HashSet<String>();
		Collection<ShFile> f;

		f = ShFiles.glob(p, new ShFileSystemStub2());
		for(ShFile x : f) {
			b.add(x.toString());
		}
		assertEquals(a, b);
	}

	public void testGlob001() {
		eqs("/*", "/haruka", "/chihaya", "/yukiho", "/azusa", "/ritsuko");
		eqs("/*a", "/haruka", "/chihaya", "/azusa");
	}

	public void testGlob002() {
		eqs("/*a/*o", "/haruka/yukiho", "/haruka/ritsuko",
				"/chihaya/yukiho", "/chihaya/ritsuko",
				"/azusa/yukiho", "/azusa/ritsuko");
	}

	public void testGlob003() {
		eqs("*", "/takane", "/hibiki", "/miki", "/yayoi");
		eqs("*e", "/takane");
	}

	public void testGlob004() {
		eqs("*e/*i", "/takane/hibiki", "/takane/miki", "/takane/yayoi");
	}

	public void testGlob005() {
		eqs("/[hc]*", "/haruka", "/chihaya");
		eqt("/[*?]*", "/***", "/???");
	}

	public void testGlob006() {
		eqt("/\\**", "/***");
		eqt("/\\?*", "/???");
		eqt("/\\[*", "/[a-z]");
	}

	public void testGlob007() {
		eqt("/'***'", "/***");
		eqt("/'*'*", "/***");
		eqt("/'*'''*", "/***");
	}

	public void testGlob008() {
		eqt("/\"***\"", "/***");
		eqt("/\"*\"*", "/***");
		eqt("/\"*\"\"\"*", "/***");
	}

	public void testGlob009() {
		eqt("/\"\\*\\**\"", "/***");
	}

}
